/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mariadb.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlTrace;
import com.lubanops.apm.plugin.mariadb.interceptor.PreparedStatementInteceptor;
import java.sql.SQLException;
import java.sql.Statement;
import org.mariadb.jdbc.MariaDbStatement;
import org.mariadb.jdbc.internal.com.read.resultset.SelectResultSet;

public class StatementExecuteInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                MariaDbStatement statement = (MariaDbStatement)object;
                String originsql = (String)args[0];
                Integer id = PreparedStatementInteceptor.getConnectionId((Statement)statement);
                PreparedStatementInteceptor.onStart(originsql, id);
                MysqlTrace.onStart((String)className, (String)methodName, (String)originsql, (String)originsql, (Integer)id);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                String sql = (String)args[0];
                PreparedStatementInteceptor.onError(e, sql);
                MysqlTrace.onError((Throwable)e);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        block7: {
            try {
                if (!MysqlCollector.INSTANCE.isEnable()) break block7;
                MariaDbStatement statement = (MariaDbStatement)object;
                String sql = (String)args[0];
                int updateCount = 0;
                int readCount = 0;
                SelectResultSet resultSet = null;
                try {
                    updateCount = statement.getUpdateCount();
                    resultSet = (SelectResultSet)statement.getResultSet();
                    if (resultSet != null) {
                        readCount = resultSet.getDataSize();
                    }
                }
                catch (SQLException e) {
                    LogFactory.getLogger().log(Level.SEVERE, "sql result error", (Throwable)e);
                }
                MysqlCollector.onFinally((int)updateCount, (int)readCount);
                if (resultSet != null && resultSet instanceof TransformAccess) {
                    MysqlTrace.onFinally((int)updateCount, (int)readCount, (TransformAccess)((TransformAccess)resultSet));
                } else {
                    MysqlTrace.onFinally((int)updateCount, (int)readCount, null);
                }
                MysqlCollector.onConnectionEnd((String)sql, (int)updateCount, (int)readCount);
            }
            catch (Exception ex) {
                LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
            }
        }
    }
}

