/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rabbitmq.consumer.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.plugin.rabbitmq.RabbitMqUtils;
import com.lubanops.apm.plugin.rabbitmq.common.collector.RabbitMqConnectionInvokeAggregator;
import com.lubanops.apm.plugin.rabbitmq.consumer.stats.RabbitMqConnectionConsumeInvokeStats;
import java.util.Map;

public class RabbitMqConnectionConsumeInvokeAggregator
extends RabbitMqConnectionInvokeAggregator<RabbitMqConnectionConsumeInvokeStats> {
    public void parseParameters(Map<String, String> parameters) {
    }

    public void setMaxSingleMsgBytes(int bytesCount) {
        if (!this.isEnable) {
            return;
        }
        RabbitMqConnectionConsumeInvokeStats stats = (RabbitMqConnectionConsumeInvokeStats)((Object)this.statsLocal.get());
        Long startTime = (Long)this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.setMaxSingleMsgBytes(bytesCount);
        }
    }

    public void incrementConsumedMsgCount() {
        if (!this.isEnable) {
            return;
        }
        RabbitMqConnectionConsumeInvokeStats stats = (RabbitMqConnectionConsumeInvokeStats)((Object)this.statsLocal.get());
        Long startTime = (Long)this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.incrementConsumedMsgCount();
        }
    }

    public void incrementConsumedBytesCount(int count) {
        if (!this.isEnable) {
            return;
        }
        RabbitMqConnectionConsumeInvokeStats stats = (RabbitMqConnectionConsumeInvokeStats)((Object)this.statsLocal.get());
        Long startTime = (Long)this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.incrementConsumedBytesCount(count);
        }
    }

    public void incrementManualAckCount(String connection, int ackedMsgCount) {
        if (!this.isEnable) {
            return;
        }
        RabbitMqConnectionConsumeInvokeStats stats = (RabbitMqConnectionConsumeInvokeStats)this.getValue(connection);
        if (stats != null) {
            stats.incrementManualAckCount(ackedMsgCount);
        }
    }

    public void incrementRejectCount(String connection, int rejectedMsgCount) {
        if (!this.isEnable) {
            return;
        }
        RabbitMqConnectionConsumeInvokeStats stats = (RabbitMqConnectionConsumeInvokeStats)this.getValue(connection);
        if (stats != null) {
            stats.incrementRejectCount(rejectedMsgCount);
        }
    }

    public void incrementRequeueCount(String connection, int requeuedMsgCount) {
        if (!this.isEnable) {
            return;
        }
        RabbitMqConnectionConsumeInvokeStats stats = (RabbitMqConnectionConsumeInvokeStats)this.getValue(connection);
        if (stats != null) {
            stats.incrementRequeueCount(requeuedMsgCount);
        }
    }

    @Override
    protected void doExtraCollectAfterHarvest(MonitorDataRow row, MonitorDataRow totalRow) {
        RabbitMqUtils.accumulateCount(row, "consumedMsgCount", totalRow);
        RabbitMqUtils.accumulateCount(row, "consumedBytes", totalRow);
        RabbitMqUtils.accumulateCount(row, "manualAckCount", totalRow);
        RabbitMqUtils.accumulateCount(row, "rejectCount", totalRow);
        RabbitMqUtils.accumulateCount(row, "requeueCount", totalRow);
        RabbitMqUtils.accumulateCount(row, "unackedMsgCount", totalRow);
        RabbitMqUtils.setMax(row, "maxSingleMsgBytes", totalRow);
    }

    @Override
    protected Class<RabbitMqConnectionConsumeInvokeStats> getValueType() {
        return RabbitMqConnectionConsumeInvokeStats.class;
    }

    @Override
    public String getName() {
        return "connectionConsume";
    }
}

