/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rabbitmq.consumer.collector;

import com.lubanops.apm.bootstrap.collector.CollectorManager;
import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultExceptionAggregator;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.rabbitmq.consumer.collector.RabbitMqConnectionConsumeInvokeAggregator;
import com.lubanops.apm.plugin.rabbitmq.consumer.collector.RabbitMqPushConsumeAggregator;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.ChannelN;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RabbitMqConsumerCollector
extends Collector {
    public static volatile boolean isInited = false;
    public static final RabbitMqConsumerCollector INSTANCE = new RabbitMqConsumerCollector();
    public static final RabbitMqConnectionConsumeInvokeAggregator CONNECTION_CONSUME_AGGREGATOR = new RabbitMqConnectionConsumeInvokeAggregator();
    public static final RabbitMqPushConsumeAggregator PUSH_CONSUME_AGGREGATOR = new RabbitMqPushConsumeAggregator();
    public static final DefaultExceptionAggregator EXCEPTION_AGGREGATOR = new DefaultExceptionAggregator();

    public static void onConsumeStart(AMQConnection connection) {
        CONNECTION_CONSUME_AGGREGATOR.onStart(connection);
    }

    public static void onConsumeFinally(int bytesCount, boolean hasError) {
        if (!hasError) {
            CONNECTION_CONSUME_AGGREGATOR.incrementConsumedMsgCount();
            CONNECTION_CONSUME_AGGREGATOR.incrementConsumedBytesCount(bytesCount);
            CONNECTION_CONSUME_AGGREGATOR.setMaxSingleMsgBytes(bytesCount);
        }
        CONNECTION_CONSUME_AGGREGATOR.onFinally();
    }

    public static void onHandleDeliveryStart(String identifier, ChannelN channelN) {
        PUSH_CONSUME_AGGREGATOR.onStart(identifier, channelN);
    }

    public static void onHandleDeliveryFinally(int bytesCount, boolean hasError) {
        if (!hasError) {
            PUSH_CONSUME_AGGREGATOR.incrementConsumedMsgCount();
            PUSH_CONSUME_AGGREGATOR.incrementConsumedBytesCount(bytesCount);
            PUSH_CONSUME_AGGREGATOR.setMaxSingleMsgBytes(bytesCount);
        }
        PUSH_CONSUME_AGGREGATOR.onFinally();
    }

    public static void onError(String errorTraceId, boolean pushMode) {
        CONNECTION_CONSUME_AGGREGATOR.onError(errorTraceId);
        if (pushMode) {
            PUSH_CONSUME_AGGREGATOR.onError(errorTraceId);
        }
    }

    public static int onAck(ChannelN channel, long deliveryTag, boolean multiple) {
        Set unackedTags = (Set)TransformAccessUtils.getFromLopsAttributeMap((Object)channel, (String)"unackedMessageDeliveryTags");
        int ackedMsgCount = 0;
        if (unackedTags != null) {
            String connection = channel.getConnection().toString();
            if (multiple) {
                Iterator iterator = unackedTags.iterator();
                while (iterator.hasNext()) {
                    long messageDeliveryTag = (Long)iterator.next();
                    if (messageDeliveryTag > deliveryTag) continue;
                    iterator.remove();
                    ++ackedMsgCount;
                }
            } else {
                boolean isRemoved = unackedTags.remove(deliveryTag);
                if (isRemoved) {
                    ++ackedMsgCount;
                }
            }
            CONNECTION_CONSUME_AGGREGATOR.incrementManualAckCount(connection, ackedMsgCount);
            PUSH_CONSUME_AGGREGATOR.incrementManualAckCount(ackedMsgCount);
        }
        return ackedMsgCount;
    }

    public static int[] onReject(ChannelN channel, long deliveryTag, boolean multiple, boolean requeue) {
        Set unackedTags = (Set)TransformAccessUtils.getFromLopsAttributeMap((Object)channel, (String)"unackedMessageDeliveryTags");
        int rejectedMsgCount = 0;
        int requeuedMsgCount = 0;
        if (unackedTags != null) {
            String connection = channel.getConnection().toString();
            if (multiple) {
                Iterator iterator = unackedTags.iterator();
                while (iterator.hasNext()) {
                    long messageDeliveryTag = (Long)iterator.next();
                    if (messageDeliveryTag > deliveryTag) continue;
                    iterator.remove();
                    ++rejectedMsgCount;
                }
            } else {
                boolean isRemoved = unackedTags.remove(deliveryTag);
                if (isRemoved) {
                    ++rejectedMsgCount;
                }
            }
            if (requeue) {
                requeuedMsgCount = rejectedMsgCount;
            }
            CONNECTION_CONSUME_AGGREGATOR.incrementRejectCount(connection, rejectedMsgCount);
            CONNECTION_CONSUME_AGGREGATOR.incrementRequeueCount(connection, requeuedMsgCount);
            PUSH_CONSUME_AGGREGATOR.incrementRejectCount(rejectedMsgCount);
            PUSH_CONSUME_AGGREGATOR.incrementRequeueCount(requeuedMsgCount);
        }
        return new int[]{rejectedMsgCount, requeuedMsgCount};
    }

    public static void onException(Throwable throwable) {
        EXCEPTION_AGGREGATOR.onThrowable(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initTag() {
        if (!isInited) {
            List list = CollectorManager.TAGS;
            synchronized (list) {
                if (!isInited) {
                    CollectorManager.addTag((String)"RabbitMqConsumer");
                    isInited = true;
                }
            }
        }
    }

    public void parseParameter(Map<String, String> parameters) {
        PUSH_CONSUME_AGGREGATOR.parseParameters(parameters);
    }

    public String getCollectorName() {
        return "RabbitMqConsumer";
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)CONNECTION_CONSUME_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)PUSH_CONSUME_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)EXCEPTION_AGGREGATOR);
        INSTANCE.register();
    }
}

