/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rabbitmq.consumer.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SampleFilter;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.StartTraceRequest;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.rabbitmq.RabbitMqUtils;
import com.lubanops.apm.plugin.rabbitmq.consumer.RabbitMqSampleFilter;
import com.lubanops.apm.plugin.rabbitmq.consumer.collector.RabbitMqConsumerCollector;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.ChannelN;
import java.util.Set;

public class HandleDeliveryInterceptor
implements Interceptor {
    private final ThreadLocal<Boolean> hasErrorLocal = new ThreadLocal();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            RabbitMqConsumerCollector.initTag();
            if (RabbitMqConsumerCollector.INSTANCE.isEnable() && object instanceof TransformAccess) {
                String revisedClassName = "com/rabbitmq/client/Consumer";
                String revisedMethodName = "handleDelivery";
                ChannelN channel = (ChannelN)TransformAccessUtils.getFromLopsAttributeMap((Object)object, (String)"channel");
                AMQConnection connection = channel.getConnection();
                String connectionAsString = connection.toString();
                String channelNum = String.valueOf(channel.getChannelNumber());
                Consumer consumer = (Consumer)TransformAccessUtils.getFromLopsAttributeMap((Object)object, (String)"consumer");
                String consumerTag = (String)TransformAccessUtils.getFromLopsAttributeMap((Object)object, (String)"consumerTag");
                Envelope envelope = (Envelope)TransformAccessUtils.getFromLopsAttributeMap((Object)object, (String)"envelop");
                AMQP.BasicProperties properties = (AMQP.BasicProperties)TransformAccessUtils.getFromLopsAttributeMap((Object)object, (String)"basicProperties");
                StartTraceRequest startTraceRequest = new StartTraceRequest(revisedClassName, revisedMethodName, null, null, null);
                String url = RabbitMqUtils.generateConsumerId(consumerTag, consumer);
                startTraceRequest.setRealSource(url);
                startTraceRequest.setSource(url);
                startTraceRequest.setKind("RabbitMqConsumer");
                startTraceRequest.setSampleFilter((SampleFilter)new RabbitMqSampleFilter());
                SpanEvent spanEvent = TraceCollector.onStart((StartTraceRequest)startTraceRequest);
                if (spanEvent != null) {
                    spanEvent.addTag("connection", connectionAsString);
                    spanEvent.addTag("channelNum", channelNum);
                    spanEvent.addTag("consumerTag", consumerTag);
                    RabbitMqUtils.addLubanOpsAttr(spanEvent, properties);
                }
                RabbitMqConsumerCollector.onConsumeStart(connection);
                RabbitMqConsumerCollector.onHandleDeliveryStart(url, channel);
                Set manualAckCustomers = (Set)TransformAccessUtils.getFromLopsAttributeMap((Object)channel, (String)"consumersWithManualAck");
                if (manualAckCustomers != null && manualAckCustomers.contains(consumerTag)) {
                    Set unackedMsgs = (Set)TransformAccessUtils.getFromLopsAttributeMap((Object)channel, (String)"unackedMessageDeliveryTags");
                    if (unackedMsgs.size() < 3000) {
                        unackedMsgs.add(envelope.getDeliveryTag());
                    } else {
                        LogFactory.getLogger().log(Level.WARNING, "size of unackedTags reaches RabbitMqConfig.MAX_CACHED_UNACK_TAGS_PER_CHANNEL.");
                    }
                }
            }
        }
        catch (Exception handleDeliveryException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)handleDeliveryException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (RabbitMqConsumerCollector.INSTANCE.isEnable() && object instanceof TransformAccess) {
                RabbitMqConsumerCollector.onException(e);
                RabbitMqConsumerCollector.onError(TraceCollector.getTraceId(), true);
                TraceCollector.onError((Throwable)e);
                this.hasErrorLocal.set(Boolean.TRUE);
            }
        }
        catch (Exception handleDeliveryException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)handleDeliveryException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (RabbitMqConsumerCollector.INSTANCE.isEnable() && object instanceof TransformAccess) {
                boolean hasError = false;
                if (Boolean.TRUE.equals(this.hasErrorLocal.get())) {
                    hasError = true;
                }
                int bytesCount = hasError ? 0 : (Integer)TransformAccessUtils.getFromLopsAttributeMap((Object)object, (String)"bytesCount");
                RabbitMqConsumerCollector.onConsumeFinally(bytesCount, hasError);
                RabbitMqConsumerCollector.onHandleDeliveryFinally(bytesCount, hasError);
                TraceCollector.onFinally((int)(hasError ? 500 : 200));
                this.hasErrorLocal.remove();
            }
        }
        catch (Exception handleDeliveryException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)handleDeliveryException);
        }
    }
}

