/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.cloud.sdk.auth.credentials;

import com.huawei.shade.com.cloud.sdk.ClientException;
import com.huawei.shade.com.cloud.sdk.auth.credentials.Credentials;
import com.huawei.shade.com.cloud.sdk.auth.credentials.CredentialsProvider;
import com.huawei.shade.org.apache.commons.logging.Log;
import com.huawei.shade.org.apache.commons.logging.LogFactory;
import java.util.LinkedList;
import java.util.List;

public class CredentialsProviderChain
implements CredentialsProvider {
    private static final Log log = LogFactory.getLog(CredentialsProviderChain.class);
    private List<CredentialsProvider> credentialsProviders = new LinkedList<CredentialsProvider>();
    private boolean reuseLastProvider = true;
    private CredentialsProvider lastUsedProvider;

    public CredentialsProviderChain(CredentialsProvider ... credentialsProviders) {
        if (credentialsProviders == null || credentialsProviders.length == 0) {
            throw new IllegalArgumentException("No credential providers specified");
        }
        for (CredentialsProvider provider : credentialsProviders) {
            if (provider == null) continue;
            this.credentialsProviders.add(provider);
        }
    }

    public boolean getReuseLastProvider() {
        return this.reuseLastProvider;
    }

    public void setReuseLastProvider(boolean b) {
        this.reuseLastProvider = b;
    }

    @Override
    public Credentials getCredentials() {
        if (this.reuseLastProvider && this.lastUsedProvider != null) {
            return this.lastUsedProvider.getCredentials();
        }
        for (CredentialsProvider provider : this.credentialsProviders) {
            try {
                Credentials credentials = provider.getCredentials();
                if (credentials.getAccessKeyId() == null || credentials.getSecretKey() == null) continue;
                log.debug("Loading credentials from " + provider.toString());
                this.lastUsedProvider = provider;
                return credentials;
            }
            catch (Exception e) {
                log.debug("Unable to load credentials from " + provider.toString() + ": " + e.getMessage());
            }
        }
        throw new ClientException("Unable to load credentials from any provider in the chain");
    }

    @Override
    public void refresh() {
        for (CredentialsProvider provider : this.credentialsProviders) {
            provider.refresh();
        }
    }
}

