/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.apm;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.StatsBase;
import com.lubanops.apm.bootstrap.utils.ExceptionUtil;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class ExceptionValue
implements StatsBase {
    protected AtomicInteger count = new AtomicInteger(0);
    protected AtomicReference<String> message = new AtomicReference();
    protected AtomicReference<String> stackTrace = new AtomicReference();
    private long countLast = 0L;

    public void onThrowable(Throwable t) {
        this.count.incrementAndGet();
        if (this.message.get() == null) {
            this.message.set(t.getMessage());
        }
        if (this.stackTrace.get() == null) {
            String s = ExceptionUtil.getThrowableStackTrace(t, false);
            this.stackTrace.set(s);
        }
    }

    @Override
    public MonitorDataRow getStatus() {
        MonitorDataRow row = new MonitorDataRow();
        row.put("count", this.count.get());
        row.put("message", this.message.get());
        row.put("stackTrace", this.stackTrace.get());
        return row;
    }

    @Override
    public MonitorDataRow harvest() {
        long c = this.count.get();
        long countHarvest = c - this.countLast;
        if (countHarvest <= 0L) {
            return null;
        }
        this.countLast = c;
        MonitorDataRow row = new MonitorDataRow();
        row.put("count", countHarvest);
        row.put("message", this.message.getAndSet(null));
        row.put("stackTrace", this.stackTrace.getAndSet(null));
        return row;
    }
}

