/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.sample;

import java.util.HashMap;
import java.util.Map;

public enum SamplingStrategy {
    INTELLIGENT("intelligent"),
    FIXED_RATE("fixedRate"),
    TAIL_BASED("tailBased");

    private static final Map<String, SamplingStrategy> BY_LABEL;
    private final String label;

    public static SamplingStrategy valueOfLabel(String label) {
        return BY_LABEL.get(label);
    }

    private SamplingStrategy(String label) {
        this.label = label;
    }

    public String value() {
        return this.label;
    }

    public String toString() {
        return this.label;
    }

    static {
        BY_LABEL = new HashMap<String, SamplingStrategy>();
        for (SamplingStrategy e : SamplingStrategy.values()) {
            BY_LABEL.put(e.label, e);
        }
    }
}

