/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.httpasyncclient.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.otel.OtelSpanKind;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.HttpClientCollector;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.HttpClientType;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.elasticsearch.restclient.EsUtils;
import com.lubanops.apm.plugin.elasticsearch.restclient.collector.EsRestClientCollector;
import com.lubanops.apm.plugin.httpasyncclient.HttpAsyncClientUtils;
import com.lubanops.apm.plugin.httpasyncclient.PoolInfoUtils;
import com.lubanops.apm.plugin.httpasyncclient.collector.ApacheHttpAsyncClientCollector;
import io.opentelemetry.api.trace.Span;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.RequestLine;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.conn.routing.HttpRoute;

public class RequestConnectionInterceptor
implements Interceptor {
    private static final String HTTP_METHOD = "httpMethod";

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (HttpClientCollector.INSTANCE.isEnable()) {
                Map map;
                AtomicReference requestWrapperRef = (AtomicReference)((AttributeAccess)object).getLopsFileds()[0];
                AtomicReference httpRouteRef = (AtomicReference)((AttributeAccess)object).getLopsFileds()[1];
                HttpRoute httpRoute = (HttpRoute)httpRouteRef.get();
                HttpRequestWrapper requestWrapper = (HttpRequestWrapper)requestWrapperRef.get();
                HttpHost host = httpRoute.getTargetHost();
                HttpRequest request = requestWrapper.getOriginal();
                RequestLine requestLine = request.getRequestLine();
                String hostUri = host.toURI();
                String uri = requestLine.getUri();
                if (uri.startsWith("/")) {
                    uri = host + uri;
                }
                String method = requestLine.getMethod();
                if (HttpAsyncClientUtils.isInEsBeforeCall(object)) {
                    String esNodes = EsUtils.getOrderedEsNodes((String)HttpAsyncClientUtils.getEsClusterNodes(object));
                    map = EsRestClientCollector.httpclientOnStartAsync((HttpHost)host, (String)uri, (String)method, (String)esNodes, (String)HttpClientType.Httpasyncclient4.name());
                } else {
                    map = HttpClientCollector.onStartAsync((String)hostUri, (String)uri, (String)method, (String)HttpClientType.Httpasyncclient4.name());
                }
                SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)HttpClientType.Httpasyncclient4.name(), (String)method, (String)OtelSpanKind.CLIENT.name());
                map.put("url", uri);
                if (spanEvent != null) {
                    map.put("spanevent", spanEvent);
                    spanEvent.addTag("url", uri);
                    spanEvent.addTag(HTTP_METHOD, method);
                    if (ApacheHttpAsyncClientCollector.INSTANCE.isGetPoolInfo()) {
                        PoolInfoUtils.addRoutePoolInfo2Tag(spanEvent, object, true);
                    }
                    Span otelSpan = spanEvent.getOtelSpan();
                    TraceCollector.addOtelAttribute((Span)otelSpan, (String)"http.method", (Object)method);
                    TraceCollector.addOtelAttribute((Span)otelSpan, (String)"http.url", (Object)uri);
                }
                if (object instanceof TransformAccess) {
                    ((TransformAccess)object).setLopsAttribute((Object)map);
                }
            }
        }
        catch (Exception requestConnectionInterceptor) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)requestConnectionInterceptor);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (HttpClientCollector.INSTANCE.isEnable()) {
                TraceCollector.onFinally((boolean)false);
            }
        }
        catch (Exception requestConnectionInterceptor) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)requestConnectionInterceptor);
        }
    }
}

