/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.moquette.broker.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.SinglePrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.config.ConfigManager;
import com.lubanops.apm.bootstrap.config.Stats;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mqtt.stats.MqttTopicStats;
import com.lubanops.apm.plugin.moquette.broker.SubscriptionDirectoryHolder;
import io.moquette.broker.subscriptions.CTrieSubscriptionDirectory;
import io.moquette.broker.subscriptions.Topic;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class MoquetteBrokerTopicAggregator
extends SinglePrimaryKeyAggregator<MqttTopicStats> {
    private static final String TOPIC = "topic";
    private static final String SUBSCRIBE_COUNT = "subscribeCount";
    private final Stats requestTranceCountStats = ConfigManager.getRequestTranceCountStats();

    public boolean sample() {
        return this.requestTranceCountStats.sampleCount.addAndGet(1) <= this.requestTranceCountStats.getThreshold();
    }

    public void parseParameters(Map<String, String> parameters) {
    }

    public void onReceivePublishMsg(String topic, int bytesCount) {
        MqttTopicStats stats = (MqttTopicStats)this.getValue(topic);
        stats.onReceiveMsg(bytesCount);
    }

    public void onSendPublishMsg(String topic, int bytesCount) {
        MqttTopicStats stats = (MqttTopicStats)this.getValue(topic);
        stats.onSendMsg(bytesCount);
    }

    public List<MonitorDataRow> harvest() {
        if (this.valueStats.isEmpty()) {
            return null;
        }
        this.requestTranceCountStats.sampleCount.set(0);
        ArrayList<MonitorDataRow> rowList = new ArrayList<MonitorDataRow>();
        try {
            for (Map.Entry entry : this.valueStats.entrySet()) {
                Method getSubsMethod;
                Class<Object> dirClass;
                Class<Object> topicClass;
                String topic = (String)entry.getKey();
                MqttTopicStats stats = (MqttTopicStats)entry.getValue();
                MonitorDataRow row = stats.harvest();
                try {
                    topicClass = Class.forName("io.moquette.spi.impl.subscriptions.Topic");
                    dirClass = Class.forName("io.moquette.spi.impl.subscriptions.SubscriptionsDirectory");
                    getSubsMethod = dirClass.getMethod("matches", topicClass);
                }
                catch (ClassNotFoundException notFoundException) {
                    topicClass = Topic.class;
                    dirClass = CTrieSubscriptionDirectory.class;
                    getSubsMethod = dirClass.getMethod("matchWithoutQosSharpening", topicClass);
                }
                Constructor<Object> topicConstructor = topicClass.getConstructor(String.class);
                int subscriptionCount = 0;
                CopyOnWriteArrayList<Object> dirList = SubscriptionDirectoryHolder.getDirectoryList();
                for (Object e : dirList) {
                    Collection set = (Collection)getSubsMethod.invoke(e, topicConstructor.newInstance(topic));
                    subscriptionCount += set.size();
                }
                row.put((Object)SUBSCRIBE_COUNT, (Object)subscriptionCount);
                this.setPrimaryKey(row, topic);
                rowList.add(row);
            }
        }
        catch (Exception exception) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)exception);
            return new ArrayList<MonitorDataRow>();
        }
        return rowList;
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        HashMap<String, List<MonitorDataRow>> res = new HashMap<String, List<MonitorDataRow>>();
        ArrayList<MonitorDataRow> totalRowList = new ArrayList<MonitorDataRow>();
        long totalMsgReceivedCount = 0L;
        long totalMsgSentCount = 0L;
        long totalBytesReceived = 0L;
        long totalBytesSent = 0L;
        if (collected != null && !collected.isEmpty()) {
            for (MonitorDataRow row : collected) {
                Long msgReceivedCount = (Long)row.get((Object)"msgReceivedCount");
                Long msgSentCount = (Long)row.get((Object)"msgSentCount");
                Long bytesReceived = (Long)row.get((Object)"bytesReceived");
                Long bytesSent = (Long)row.get((Object)"bytesSent");
                if (msgReceivedCount == null) {
                    msgReceivedCount = 0L;
                }
                if (msgSentCount == null) {
                    msgSentCount = 0L;
                }
                if (bytesReceived == null) {
                    bytesReceived = 0L;
                }
                if (bytesSent == null) {
                    bytesSent = 0L;
                }
                totalMsgReceivedCount += msgReceivedCount.longValue();
                totalMsgSentCount += msgSentCount.longValue();
                totalBytesReceived += bytesReceived.longValue();
                totalBytesSent += bytesSent.longValue();
            }
        }
        MonitorDataRow totalRow = new MonitorDataRow();
        totalRow.put((Object)"msgReceivedCount", (Object)totalMsgReceivedCount);
        totalRow.put((Object)"msgSentCount", (Object)totalMsgSentCount);
        totalRow.put((Object)"bytesReceived", (Object)totalBytesReceived);
        totalRow.put((Object)"bytesSent", (Object)totalBytesSent);
        totalRowList.add(totalRow);
        res.put("total", totalRowList);
        return res;
    }

    protected Class<MqttTopicStats> getValueType() {
        return MqttTopicStats.class;
    }

    protected String primaryKey() {
        return TOPIC;
    }

    public String getName() {
        return "brokerTopic";
    }
}

