/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rocketmq.consumer.stats;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.plugin.rocketmq.common.stats.RocketMqInvokeStats;
import java.util.concurrent.atomic.AtomicLong;

public class RocketMqConsumeStats
extends RocketMqInvokeStats {
    private volatile long consumedMsgCountOld;
    private volatile long consumedBytesOld;
    private volatile long reconsumeTimesOld;
    private final AtomicLong consumedMsgCount = new AtomicLong();
    private final AtomicLong consumedBytes = new AtomicLong();
    private final AtomicLong reconsumeTimes = new AtomicLong();

    public void incrementConsumedMsgCount(int count) {
        this.consumedMsgCount.addAndGet(count);
    }

    public void incrementConsumedBytesCount(int count) {
        this.consumedBytes.addAndGet(count);
    }

    public void incrementReconsumeTimes(int count) {
        this.reconsumeTimes.addAndGet(count);
    }

    @Override
    public MonitorDataRow getStatus() {
        MonitorDataRow row = super.getStatus();
        row.put((Object)"consumedMsgCount", (Object)this.consumedMsgCount.get());
        row.put((Object)"consumedBytes", (Object)this.consumedBytes.get());
        row.put((Object)"reconsumeTimes", (Object)this.reconsumeTimes.get());
        return row;
    }

    @Override
    public MonitorDataRow harvest(int[] newRanges) {
        long consumedMsgCountNew = this.consumedMsgCount.get();
        long consumedBytesNew = this.consumedBytes.get();
        long reconsumeTimesNew = this.reconsumeTimes.get();
        MonitorDataRow row = super.harvest(newRanges);
        if (row != null) {
            row.put((Object)"consumedMsgCount", (Object)(consumedMsgCountNew - this.consumedMsgCountOld));
            row.put((Object)"consumedBytes", (Object)(consumedBytesNew - this.consumedBytesOld));
            row.put((Object)"reconsumeTimes", (Object)(reconsumeTimesNew - this.reconsumeTimesOld));
        }
        this.consumedMsgCountOld = consumedMsgCountNew;
        this.consumedBytesOld = consumedBytesNew;
        this.reconsumeTimesOld = reconsumeTimesNew;
        return row;
    }
}

