/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rocketmq.producer.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.rocketmq.RocketMqContext;
import com.lubanops.apm.plugin.rocketmq.RocketMqUtils;
import com.lubanops.apm.plugin.rocketmq.producer.collector.RocketMqProducerCollector;
import org.apache.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;

public class SendKernelImplInterceptor
implements Interceptor {
    private final ThreadLocal<Boolean> hasErrorLocal = new ThreadLocal();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (RocketMqProducerCollector.INSTANCE.isEnable()) {
                DefaultMQProducerImpl producerImp = (DefaultMQProducerImpl)object;
                DefaultMQProducer producer = (DefaultMQProducer)((AttributeAccess)producerImp).getLopsFileds()[0];
                String clientId = RocketMqUtils.getClientId(producerImp);
                String group = producer.getProducerGroup();
                Message msg = (Message)args[0];
                int msgCount = RocketMqUtils.getMessageCount(msg);
                int msgBytes = msg.getBody().length;
                MessageQueue mq = (MessageQueue)args[1];
                SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"RocketMqProducer");
                RocketMqProducerCollector.onPublishStart(clientId, group, mq);
                if (spanEvent != null) {
                    RocketMqUtils.setMsgTraceId(msg);
                    spanEvent.addTag("topic", mq.getTopic());
                    spanEvent.addTag("brokerName", mq.getBrokerName());
                    spanEvent.addTag("queueId", String.valueOf(mq.getQueueId()));
                    spanEvent.addTag("tags", msg.getTags());
                    spanEvent.addTag("msgCount", String.valueOf(msgCount));
                    spanEvent.addTag("msgBytes", String.valueOf(msgBytes));
                }
                String nameServer = producer.getNamesrvAddr();
                RocketMqContext.NAMESERVER_LOCAL.set(nameServer);
            }
        }
        catch (Exception rocketMqPublishException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rocketMqPublishException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (RocketMqProducerCollector.INSTANCE.isEnable()) {
                RocketMqProducerCollector.onException(e);
                TraceCollector.onError((Throwable)e);
                this.hasErrorLocal.set(Boolean.TRUE);
            }
        }
        catch (Exception rocketMqPublishException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rocketMqPublishException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (RocketMqProducerCollector.INSTANCE.isEnable()) {
                boolean isSendFailed = false;
                if (Boolean.TRUE.equals(this.hasErrorLocal.get())) {
                    isSendFailed = true;
                }
                Message msg = (Message)args[0];
                int msgCount = RocketMqUtils.getMessageCount(msg);
                int msgBytes = msg.getBody().length;
                SendResult sendResult = (SendResult)result;
                SpanEvent spanEvent = TraceCollector.getSpanEvent();
                if (result != null) {
                    SendStatus sendStatus = sendResult.getSendStatus();
                    if (!SendStatus.SEND_OK.equals((Object)sendStatus)) {
                        isSendFailed = true;
                    }
                    if (spanEvent != null) {
                        spanEvent.addTag("sendResult", sendStatus.name());
                        spanEvent.addTag("messageId", sendResult.getMsgId());
                        spanEvent.addTag("queueOffset", String.valueOf(sendResult.getQueueOffset()));
                    }
                }
                if (isSendFailed) {
                    RocketMqProducerCollector.onPublishError(TraceCollector.getTraceId());
                }
                RocketMqProducerCollector.onPublishFinally(msgCount, msgBytes, isSendFailed);
                TraceCollector.onFinally();
                this.hasErrorLocal.remove();
                RocketMqContext.NAMESERVER_LOCAL.remove();
            }
        }
        catch (Exception rocketMqPublishException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rocketMqPublishException);
        }
    }
}

