/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.transport.websocket.future;

import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.integration.access.Message;
import com.lubanops.apm.integration.transport.websocket.future.FutureManagementService;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class MessageFuture {
    private static final Logger LOGGER = LogFactory.getLogger();
    public FutureManagementService futureManagement;
    private CountDownLatch latch = new CountDownLatch(1);
    private Message message;
    private long messageId;
    private long timestamp = System.currentTimeMillis();
    private long elapse1 = 0L;
    private long elapse2 = 0L;
    private long timeout;

    public MessageFuture(FutureManagementService futureManagement, long messageId, long timeout) {
        this.futureManagement = futureManagement;
        this.messageId = messageId;
        this.timeout = timeout;
    }

    public Message get() {
        try {
            this.latch.await(this.timeout, TimeUnit.MILLISECONDS);
            if (LOGGER.isLoggable(Level.FINE)) {
                long now = System.currentTimeMillis();
                this.elapse1 = now - this.timestamp;
                if (this.elapse1 > 200L) {
                    LOGGER.log(Level.FINE, String.format(Locale.ENGLISH, "message finished,id[%d]born[%d]elapse1[%d]", this.timestamp, this.messageId, this.elapse1));
                }
            }
            this.futureManagement.removeFuture(this.messageId);
            return this.message;
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public long getFutureAge() {
        return System.currentTimeMillis() - this.timestamp;
    }

    public void taskFinished(Message message) {
        this.message = message;
        long now = System.currentTimeMillis();
        this.elapse1 = now - this.timestamp;
        if (this.elapse1 > 200L) {
            LOGGER.log(Level.FINE, String.format(Locale.ENGLISH, "message finished,id[%d]born[%d]elapse1[%d]", this.timestamp, this.messageId, this.elapse1));
        }
        this.latch.countDown();
        this.elapse2 = System.currentTimeMillis() - now;
        LOGGER.log(Level.FINE, String.format(Locale.ENGLISH, "message finished,id[%d]born[%d]elapse1[%d]elapse2[%d]", this.timestamp, this.messageId, this.elapse1, this.elapse2));
    }

    public Message getMessage() {
        return this.message;
    }
}

