/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.dubbo.collector.sampling;

import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.util.Map;
import java.util.regex.Pattern;

public class MethodPattern {
    private static final String METHOD_PRIMARY_KEY_WILDCARD = "*";
    private boolean isLiteral = Boolean.TRUE;
    private String group;
    private String service;
    private String version;
    private String method;
    private Pattern pattern;
    private Map<String, String> attachmentPattern;

    public MethodPattern(String group, String service, String version, String method, Map<String, String> attachmentPattern) {
        this.group = group;
        this.service = service;
        this.version = version;
        this.method = method;
        this.attachmentPattern = attachmentPattern;
    }

    public MethodPattern build() {
        if (StringUtils.isBlank((String)this.group) && StringUtils.isBlank((String)this.service) && StringUtils.isBlank((String)this.version) && StringUtils.isBlank((String)this.method)) {
            throw new IllegalArgumentException("match field in pattern cannot be all empty");
        }
        if (!StringUtils.isBlank((String)this.service) && this.service.indexOf(METHOD_PRIMARY_KEY_WILDCARD) != -1) {
            this.isLiteral = Boolean.FALSE;
        }
        this.group = this.getValue(this.group, METHOD_PRIMARY_KEY_WILDCARD);
        this.service = this.getValue(this.service, METHOD_PRIMARY_KEY_WILDCARD);
        this.version = this.getValue(this.version, METHOD_PRIMARY_KEY_WILDCARD);
        this.method = this.getValue(this.method, METHOD_PRIMARY_KEY_WILDCARD);
        if (!this.isLiteral) {
            String regPath = this.getRegPath(this.service);
            this.pattern = Pattern.compile(regPath);
        }
        return this;
    }

    private String getValue(String value, String defaultValue) {
        if (StringUtils.isBlank((String)value)) {
            return defaultValue;
        }
        return value;
    }

    boolean matches(String group, String service, String version, String method) {
        boolean match = Boolean.TRUE;
        match &= this.matchKey(group, this.group);
        match = this.isLiteral ? (match &= this.matchKey(service, this.service)) : (match &= this.pattern.matcher(service).matches());
        match &= this.matchKey(version, this.version);
        return match &= this.matchKey(method, this.method);
    }

    private boolean matchKey(String key, String keyReg) {
        if (METHOD_PRIMARY_KEY_WILDCARD.equals(keyReg)) {
            return true;
        }
        return keyReg.equals(key);
    }

    private String getRegPath(String path) {
        char[] chars = path.toCharArray();
        int len = chars.length;
        StringBuilder sb = new StringBuilder();
        boolean preX = false;
        for (int i = 0; i < len; ++i) {
            if (chars[i] == '*') {
                if (preX) {
                    sb.append(".*");
                    preX = false;
                    continue;
                }
                if (i + 1 == len) {
                    sb.append(".*");
                    continue;
                }
                preX = true;
                continue;
            }
            if (preX) {
                sb.append(".*");
                preX = false;
            }
            if (chars[i] == '?') {
                sb.append('.');
                continue;
            }
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    public boolean isLiteral() {
        return this.isLiteral;
    }

    public void setLiteral(boolean literal) {
        this.isLiteral = literal;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public Map<String, String> getAttachmentPattern() {
        return this.attachmentPattern;
    }

    public void setAttachmentPattern(Map<String, String> attachmentPattern) {
        this.attachmentPattern = attachmentPattern;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MethodPattern{");
        sb.append("isLiteral=").append(this.isLiteral);
        sb.append(", group='").append(this.group).append('\'');
        sb.append(", service='").append(this.service).append('\'');
        sb.append(", version='").append(this.version).append('\'');
        sb.append(", method='").append(this.method).append('\'');
        sb.append(", pattern=").append(this.pattern);
        sb.append(", attachmentPattern=").append(this.attachmentPattern);
        sb.append('}');
        return sb.toString();
    }
}

