/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.dubbo.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.collector.api.FutureStatsAccessor;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.Tags;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.dubbo.collector.consumer.DubboConsumerCollector;
import com.lubanops.apm.plugin.dubbo.collector.provider.DubboProviderCollector;
import com.lubanops.apm.plugin.dubbo.interceptor.MonitorFilterOnErrorInterceptor;
import com.lubanops.apm.plugin.dubbo.utils.InterceptorAssist;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;

public class MonitorFilterOnResponseInterceptor
implements Interceptor {
    private final MonitorFilterOnErrorInterceptor monitorFilterOnErrorInterceptor = new MonitorFilterOnErrorInterceptor();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object invokeResult, String className, String methodName) {
        Result result = (Result)args[0];
        Invoker invoker = (Invoker)args[1];
        Invocation invocation = (Invocation)args[2];
        if (result.hasException()) {
            this.monitorFilterOnErrorInterceptor.onFinally(object, new Object[]{result.getException(), invoker, invocation}, null, className, methodName);
            return;
        }
        if (InterceptorAssist.isEnable(invoker) && invocation instanceof TransformAccess) {
            String apmRemoteEnvId;
            TransformAccess transformAccess = (TransformAccess)invocation;
            FutureStatsAccessor futureStatsAccessor = (FutureStatsAccessor)transformAccess.getLopsAttribute();
            SpanEvent spanEvent = futureStatsAccessor.getSpanEvent();
            String traceId = "";
            if (spanEvent != null) {
                traceId = spanEvent.getTraceId();
                long timeUsed = System.nanoTime() - spanEvent.getStartNanoTime();
                spanEvent.setTimeUsed(timeUsed);
                spanEvent.addTag(Tags.asyncTimeUsed.name(), String.valueOf(spanEvent.getTimeUsed()));
                spanEvent.setCode(200);
            }
            String string = apmRemoteEnvId = "consumer".equals(invoker.getUrl().getParameter("side")) ? invoker.getUrl().getParameter(Headers.ENV_ID.getValue()) : invocation.getAttachment(Headers.ENV_ID.getValue());
            if ("consumer".equals(invoker.getUrl().getParameter("side"))) {
                DubboConsumerCollector.onResponse(futureStatsAccessor.getStartTime(), traceId, futureStatsAccessor.getServiceName(), futureStatsAccessor.getMethod(), apmRemoteEnvId, !result.hasException());
            } else {
                String apmResult;
                DubboProviderCollector.onResponse(futureStatsAccessor.getStartTime(), traceId, futureStatsAccessor.getServiceName(), futureStatsAccessor.getMethod(), apmRemoteEnvId, !result.hasException());
                if (spanEvent != null && (apmResult = result.getValue().toString()) != null && apmResult.length() > 0) {
                    spanEvent.addTag("result", apmResult, DubboProviderCollector.INSTANCE.getInvocationLength());
                }
            }
            TraceCollector.sendSpanEvent((SpanEvent)spanEvent);
        }
    }
}

