/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.connectionpool;

import com.lubanops.apm.bootstrap.collector.api.SinglePrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.plugin.connectionpool.DBConnectionStats;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import java.util.Map;

public abstract class DBConnectionAggregator
extends SinglePrimaryKeyAggregator<DBConnectionStats> {
    private final ThreadLocal<DBConnectionStats> statsLocal = new ThreadLocal();
    private final ThreadLocal<Long> startTimeLocal = new ThreadLocal();
    private final ThreadLocal<Integer> activeCountLocal = new ThreadLocal();
    private final ThreadLocal<Integer> poolingCountLocal = new ThreadLocal();
    private final ThreadLocal<Integer> waitingThreadCountLocal = new ThreadLocal();
    private static final String URL = "url";
    private int timeSpanThreshold = 1;
    private boolean getPoolInfo = false;

    public void parseParameters(Map<String, String> parameters) {
        Integer timeSpanThreshold = ParameterParseUtil.getInteger(parameters, (String)this.getTimeSpanThresholdFieldName());
        Boolean getPoolInfo = ParameterParseUtil.getBoolean(parameters, (String)this.getPoolInfoFieldName());
        if (timeSpanThreshold != null) {
            this.timeSpanThreshold = timeSpanThreshold;
        }
        if (getPoolInfo != null) {
            this.getPoolInfo = getPoolInfo;
        }
    }

    public void onStart(String dataSource) {
        if (!this.isEnable) {
            return;
        }
        if (dataSource == null) {
            dataSource = "unknown";
        }
        DBConnectionStats stats = (DBConnectionStats)this.getValue(dataSource);
        long startTime = stats.onStart();
        this.statsLocal.set(stats);
        this.startTimeLocal.set(startTime);
    }

    public void onThrowable(Throwable t) {
        if (!this.isEnable) {
            return;
        }
        DBConnectionStats stats = this.statsLocal.get();
        if (stats != null) {
            stats.onThrowable(t);
        }
    }

    public void onFinally() {
        if (!this.isEnable) {
            return;
        }
        DBConnectionStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            Long endTime = System.nanoTime();
            stats.onFinally(endTime - startTime);
            this.statsLocal.set(null);
            this.startTimeLocal.set(null);
        }
    }

    public int getTimeSpanThreshold() {
        return this.timeSpanThreshold;
    }

    public boolean isGetPoolInfo() {
        return this.getPoolInfo;
    }

    protected Class<DBConnectionStats> getValueType() {
        return DBConnectionStats.class;
    }

    protected String primaryKey() {
        return URL;
    }

    public String getName() {
        return "connection";
    }

    public abstract String getTimeSpanThresholdFieldName();

    public abstract String getPoolInfoFieldName();

    public Integer getActiveCount() {
        return this.activeCountLocal.get();
    }

    public Integer getPoolingCount() {
        return this.poolingCountLocal.get();
    }

    public Integer getWaitThreadCount() {
        return this.waitingThreadCountLocal.get();
    }

    public void setActiveCount(int num) {
        this.activeCountLocal.set(num);
    }

    public void setPoolingCount(int num) {
        this.poolingCountLocal.set(num);
    }

    public void setWaitingThreadCount(int num) {
        this.waitingThreadCountLocal.set(num);
    }

    public void setCounts(int activeCount, int poolingCount, int waitThreadCount) {
        this.activeCountLocal.set(activeCount);
        this.poolingCountLocal.set(poolingCount);
        this.waitingThreadCountLocal.set(waitThreadCount);
    }

    public void clearCounts() {
        this.activeCountLocal.set(null);
        this.poolingCountLocal.set(null);
        this.waitingThreadCountLocal.set(null);
    }
}

