/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.cse.interceptor;

import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.url.collector.ResponseCache;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SampleFilter;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.StartTraceRequest;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.cse.collector.provider.CSEProviderCollector;
import com.lubanops.apm.plugin.cse.collector.provider.CSESampleFilter;
import com.lubanops.apm.plugin.cse.collector.provider.config.CSEStatsConfig;
import com.lubanops.apm.plugin.cse.interceptor.Handler;
import com.lubanops.apm.plugin.cse.utils.CSEUtils;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.event.InvocationBusinessMethodFinishEvent;
import org.apache.servicecomb.core.event.InvocationBusinessMethodStartEvent;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.InvocationStartEvent;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;

public class ProviderHandler
implements Handler {
    @Override
    public void onInvocationStart(InvocationStartEvent event) {
        try {
            if (CSEProviderCollector.INSTANCE.isEnable()) {
                Invocation invocation = event.getInvocation();
                RestOperationMeta restOperationMeta = (RestOperationMeta)invocation.getOperationMeta().getExtData("swaggerRestOperation");
                String uri = restOperationMeta.getAbsolutePath();
                String httpMethod = invocation.getOperationMeta().getHttpMethod();
                String envId = CSEUtils.getHeader(Headers.ENV_ID.getValue(), invocation);
                HttpServletRequestEx requestEx = invocation.getRequestEx();
                String realPathWithQueryStr = null;
                if (requestEx != null) {
                    String realPath;
                    realPathWithQueryStr = realPath = requestEx.getRequestURI();
                    String queryString = requestEx.getQueryString();
                    if (queryString != null && !"".equals(queryString)) {
                        realPathWithQueryStr = realPath + "?" + queryString;
                    }
                }
                String traceId = CSEUtils.getHeader(Headers.TRACE_ID.getValue(), invocation);
                String gtraceId = CSEUtils.getHeader(Headers.GTRACE_ID.getValue(), invocation);
                String userFlag = CSEUtils.getHeader(Headers.USER_FLAG.getValue(), invocation);
                String policyId = CSEUtils.getHeader(Headers.POLICY_ID.getValue(), invocation);
                String spanId = CSEUtils.getHeader(Headers.SPAN_ID.getValue(), invocation);
                String eventId = CSEUtils.getHeader(Headers.SOURCE_EVENT_ID.getValue(), invocation);
                String domainId = CSEUtils.getHeader(Headers.DOMAIN_ID.getValue(), invocation);
                String domainType = CSEUtils.getHeader(Headers.DOMAIN_TYPE.getValue(), invocation);
                String otelHeader = CSEUtils.getHeader(Headers.OTEL_HEADER.getValue(), invocation);
                StartTraceRequest startTraceRequest = new StartTraceRequest("CSE", invocation.getInvocationQualifiedName(), traceId, spanId, gtraceId);
                startTraceRequest.setKind("CSE");
                startTraceRequest.setSource(uri);
                startTraceRequest.setRealSource(realPathWithQueryStr);
                startTraceRequest.setHttpMethod(httpMethod);
                startTraceRequest.setSourceEventId(eventId);
                startTraceRequest.setDomainId(domainId);
                startTraceRequest.setDomainType(domainType);
                startTraceRequest.setSampleFilter((SampleFilter)new CSESampleFilter());
                startTraceRequest.setPolicyId(policyId);
                startTraceRequest.setOtelTraceParent(otelHeader);
                SpanEvent spanEvent = null;
                if (!CSEStatsConfig.isExcludeUrl(uri)) {
                    spanEvent = TraceCollector.onStart((StartTraceRequest)startTraceRequest);
                    if (!TraceCollector.isSameDomain((String)domainId, (String)domainType)) {
                        envId = null;
                    }
                    CSEProviderCollector.onStart(uri, httpMethod, envId);
                }
                Map<String, Object> map = CSEProviderCollector.getThreadLocalMap();
                invocation.addLocalContext("lubanopsapmThreadLocalMap", map);
                invocation.addLocalContext("lubanopsapmEnvId", (Object)envId);
                CSEProviderCollector.clearThreadLocal();
                this.addHeaderValue(spanEvent, invocation);
                invocation.addLocalContext("lubanopsapmSpanEvent", (Object)spanEvent);
                invocation.addLocalContext("lubanopsapmGtraceId", (Object)TraceCollector.getVirtualTraceId());
                invocation.addLocalContext("lubanopsapmUserFlag", (Object)userFlag);
                if (spanEvent != null && spanEvent.hasSamplingPolicy()) {
                    invocation.addLocalContext("lubanopsapmPolicyId", (Object)spanEvent.getPolicyId());
                } else {
                    invocation.addLocalContext("lubanopsapmPolicyId", (Object)policyId);
                }
                TraceCollector.setSpanEvent(null);
                this.setResponseTraceId(spanEvent, (String)TraceCollector.G_TRACE_ID_THREAD_LOCAL.get());
                TraceCollector.G_TRACE_ID_THREAD_LOCAL.set(null);
            }
        }
        catch (Throwable e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", e1);
        }
    }

    private void addHeaderValue(SpanEvent spanEvent, Invocation invocation) {
        String[] headKeys;
        if (spanEvent != null && (headKeys = CSEProviderCollector.INSTANCE.getHeaderKeys()) != null) {
            for (String headKey : headKeys) {
                String value = CSEUtils.getHeader(headKey, invocation);
                spanEvent.addTag(headKey, value);
            }
        }
    }

    private void setResponseTraceId(SpanEvent spanEvent, String gtraceId) {
        Object responseObj = ResponseCache.getResponse();
        if (responseObj != null && spanEvent != null && responseObj instanceof HttpServletResponse) {
            ((HttpServletResponse)responseObj).setHeader(Headers.GTRACE_ID.getValue(), gtraceId);
            ((HttpServletResponse)responseObj).setHeader(Headers.TRACE_ID.getValue(), spanEvent.getTraceId());
            ((HttpServletResponse)responseObj).setHeader(Headers.SPAN_ID.getValue(), spanEvent.getSpanId());
        }
    }

    @Override
    public void onInvocationFinish(InvocationFinishEvent event) {
        try {
            if (CSEProviderCollector.INSTANCE.isEnable()) {
                InvocationFinishEvent invocationFinishEvent = event;
                int code = invocationFinishEvent.getResponse().getStatusCode();
                Invocation invocation = event.getInvocation();
                Map map = (Map)invocation.getLocalContext("lubanopsapmThreadLocalMap");
                invocation.addLocalContext("lubanopsapmThreadLocalMap", null);
                CSEProviderCollector.setThreadLocalMap(map);
                RestOperationMeta restOperationMeta = (RestOperationMeta)invocation.getOperationMeta().getExtData("swaggerRestOperation");
                String url = restOperationMeta.getAbsolutePath();
                String envId = (String)invocation.getLocalContext("lubanopsapmEnvId");
                invocation.addLocalContext("lubanopsapmEnvId", null);
                Boolean hasException = TraceCollector.hasException();
                boolean hasError = CSEProviderCollector.onFinally(code, envId, url, hasException);
                SpanEvent spanEvent = (SpanEvent)invocation.getLocalContext("lubanopsapmSpanEvent");
                if (spanEvent != null) {
                    CSEUtils.saveBizCodeToSpanEvent(event.getResponse(), spanEvent);
                    CSEUtils.toStringInvocationStageTrace(invocation.getInvocationStageTrace(), spanEvent);
                    CSEUtils.collectResponseBody(invocation, spanEvent, event);
                    invocation.addLocalContext("lubanopsapmSpanEvent", null);
                    TraceCollector.setSpanEvent((SpanEvent)spanEvent);
                }
                TraceCollector.onFinally((int)code, (boolean)hasError);
            }
        }
        catch (Throwable e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", e1);
        }
    }

    @Override
    public void onInvocationBusinessStart(InvocationBusinessMethodStartEvent event) {
        try {
            if (CSEProviderCollector.INSTANCE.isEnable()) {
                Invocation invocation = event.getInvocation();
                HttpServletRequestEx requestEx = invocation.getRequestEx();
                SpanEvent spanEvent = (SpanEvent)invocation.getLocalContext("lubanopsapmSpanEvent");
                String gTraceId = (String)invocation.getLocalContext("lubanopsapmGtraceId");
                String userFlag = (String)invocation.getLocalContext("lubanopsapmUserFlag");
                String policyId = (String)invocation.getLocalContext("lubanopsapmPolicyId");
                TraceCollector.G_TRACE_ID_THREAD_LOCAL.set(gTraceId);
                TraceCollector.USER_FLAG_THREAD_LOCAL.set(userFlag);
                if (StringUtils.isBlank((CharSequence)TraceCollector.getPolicyId()) && policyId != null) {
                    TraceCollector.POLICY_ID_THREAD_LOCAL.set(policyId);
                }
                TraceCollector.setSpanEvent((SpanEvent)spanEvent);
                TraceCollector.onStart((String)"CSE", (String)invocation.getOperationMeta().getSchemaQualifiedName(), (String)"CSE");
                CSEUtils.collectRequestBody(spanEvent, requestEx, invocation);
            }
        }
        catch (Throwable e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", e1);
        }
    }

    @Override
    public void onInvocationBusinessFinish(InvocationBusinessMethodFinishEvent event) {
        try {
            if (CSEProviderCollector.INSTANCE.isEnable()) {
                TraceCollector.onFinally();
                TraceCollector.clear();
            }
        }
        catch (Throwable e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", e1);
        }
    }
}

