/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.elasticsearch.restclient;

import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.utils.AntPathMatcher;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.http.HttpHost;

public final class EsUtils {
    public static final String INDEX_FORMAT = "{index}";
    public static final String TYPE_FORMAT = "{type}";
    public static final String ID_FORMAT = "{id}";
    public static final String ES_INDEX = "esIndex";
    public static final String ES_TYPE = "esType";
    public static final String ES_ID = "esId";
    public static final ThreadLocal<String> INDEX_LOCAL = new ThreadLocal();
    public static final ThreadLocal<String> TYPE_LOCAL = new ThreadLocal();
    public static final ThreadLocal<String> ID_LOCAL = new ThreadLocal();
    private static final AntPathMatcher MATCHER = new AntPathMatcher();
    private static Map<String, String> indexRegexTargetMap = new HashMap<String, String>();

    public static void setIndexRegexTargetMap(List<RegexConversionPattern> patterns) {
        indexRegexTargetMap = new HashMap<String, String>();
        for (RegexConversionPattern pattern : patterns) {
            String regex = pattern.getRegex();
            if (regex == null) continue;
            String target = pattern.getTarget();
            if (target == null) {
                target = regex;
            }
            indexRegexTargetMap.put(regex, target);
        }
    }

    public static String getHostAddress(HttpHost host) {
        InetAddress address = host.getAddress();
        if (address != null) {
            return address.toString();
        }
        return host.getHostName() + ":" + host.getPort();
    }

    public static void clearUrlInfoLocals() {
        INDEX_LOCAL.remove();
        TYPE_LOCAL.remove();
        ID_LOCAL.remove();
    }

    public static void saveUrlInfoLocalsFromObj(Object obj) {
        if (obj instanceof TransformAccess) {
            String index = (String)TransformAccessUtils.getFromLopsAttributeMap((Object)obj, (String)ES_INDEX);
            String type = (String)TransformAccessUtils.getFromLopsAttributeMap((Object)obj, (String)ES_TYPE);
            String id = (String)TransformAccessUtils.getFromLopsAttributeMap((Object)obj, (String)ES_ID);
            if (index != null) {
                INDEX_LOCAL.set(index);
            }
            if (type != null) {
                TYPE_LOCAL.set(type);
            }
            if (id != null) {
                ID_LOCAL.set(id);
            }
        }
    }

    public static void saveUrlInfoLocalsToObj(Object obj) {
        if (obj instanceof TransformAccess) {
            String index = INDEX_LOCAL.get();
            String type = TYPE_LOCAL.get();
            String id = ID_LOCAL.get();
            if (index != null) {
                TransformAccessUtils.saveToLopsAttributeMap((Object)obj, (String)ES_INDEX, (Object)index);
            }
            if (type != null) {
                TransformAccessUtils.saveToLopsAttributeMap((Object)obj, (String)ES_TYPE, (Object)type);
            }
            if (id != null) {
                TransformAccessUtils.saveToLopsAttributeMap((Object)obj, (String)ES_ID, (Object)id);
            }
        }
    }

    public static String trimSuffix(String uri) {
        int i = uri.indexOf(63);
        return i <= 0 ? uri : uri.substring(0, i);
    }

    public static String convertEndpoint(String endpoint) {
        if ((endpoint = EsUtils.trimSuffix(endpoint)).equals("/")) {
            return endpoint;
        }
        String index = INDEX_LOCAL.get();
        String type = TYPE_LOCAL.get();
        String id = ID_LOCAL.get();
        ArrayList<ReformatCall> list = new ArrayList<ReformatCall>();
        if (index != null && !index.isEmpty()) {
            if (indexRegexTargetMap.size() == 0) {
                list.add(new ReformatCall(index, INDEX_FORMAT, true));
            } else {
                list.add(new ReformatCall(index, indexRegexTargetMap, false));
            }
        }
        if (type != null && !type.isEmpty()) {
            list.add(new ReformatCall(type, TYPE_FORMAT, true));
        }
        if (id != null && !id.isEmpty()) {
            list.add(new ReformatCall(id, ID_FORMAT, false));
        }
        Collections.sort(list);
        for (ReformatCall call : list) {
            endpoint = call.convert(endpoint);
        }
        Collections.sort(list);
        for (ReformatCall call : list) {
            endpoint = call.convertBackIfNeeded(endpoint);
        }
        return endpoint;
    }

    public static String getOrderedEsNodes(String esNodes) {
        String[] nodes = esNodes.split(",");
        TreeSet<String> set = new TreeSet<String>();
        for (String node : nodes) {
            set.add(node);
        }
        StringBuilder builder = new StringBuilder();
        for (String node : set) {
            if (builder.length() == 0) {
                builder.append(node);
                continue;
            }
            builder.append(",").append(node);
        }
        return builder.toString();
    }

    public static class RegexConversionPattern {
        String regex;
        String target;

        public String getRegex() {
            return this.regex;
        }

        public void setRegex(String regex) {
            this.regex = regex;
        }

        public String getTarget() {
            return this.target;
        }

        public void setTarget(String target) {
            this.target = target;
        }
    }

    private static class ReformatCall
    implements Comparable<ReformatCall> {
        int len;
        String strToBeReplaced;
        String pieceReplacement;
        String replacement;
        boolean convertBack;
        Map<String, String> regexTargetMap = new HashMap<String, String>();

        ReformatCall(String strToBeReplaced, String pieceReplacement, boolean convertBack) {
            this(strToBeReplaced, convertBack);
            this.pieceReplacement = pieceReplacement;
        }

        ReformatCall(String strToBeReplaced, Map<String, String> regexTargetMap, boolean convertBack) {
            this(strToBeReplaced, convertBack);
            this.regexTargetMap = regexTargetMap;
        }

        private ReformatCall(String strToBeReplaced, boolean convertBack) {
            this.strToBeReplaced = strToBeReplaced;
            this.convertBack = convertBack;
            this.len = strToBeReplaced.length();
        }

        String convert(String s) {
            String[] pieces = this.strToBeReplaced.split(",");
            StringBuilder replacementBuilder = new StringBuilder();
            for (String piece : pieces) {
                String append = "";
                if (this.pieceReplacement != null) {
                    append = this.pieceReplacement;
                } else if (this.regexTargetMap != null) {
                    for (Map.Entry<String, String> entry : this.regexTargetMap.entrySet()) {
                        if (!MATCHER.match(entry.getKey(), piece)) continue;
                        append = entry.getValue();
                        break;
                    }
                    if (append.length() == 0) {
                        append = piece;
                    }
                }
                if (replacementBuilder.length() == 0) {
                    replacementBuilder.append(append);
                    continue;
                }
                replacementBuilder.append(",").append(append);
            }
            this.replacement = replacementBuilder.toString();
            this.len = this.replacement.length();
            return s.replace(this.strToBeReplaced, this.replacement);
        }

        String convertBackIfNeeded(String s) {
            if (this.convertBack) {
                this.len = this.strToBeReplaced.length();
                return s.replace(this.replacement, this.strToBeReplaced);
            }
            return s;
        }

        @Override
        public int compareTo(ReformatCall o) {
            return Integer.valueOf(o.len).compareTo(this.len);
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

