/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.trace;

import com.lubanops.apm.bootstrap.api.HarvestListener;
import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.config.SSConfigManager;
import com.lubanops.apm.bootstrap.config.Stats;
import com.lubanops.apm.bootstrap.exception.ApmRuntimeException;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.plugin.apm.APMCollector;
import com.lubanops.apm.bootstrap.plugin.common.url.TokenBucket;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceReportService;
import com.lubanops.apm.bootstrap.utils.AgentUtils;
import com.lubanops.apm.core.common.ConnectionException;
import com.lubanops.apm.core.common.NamedThreadFactory;
import com.lubanops.apm.core.executor.standalone.ServiceThread;
import com.lubanops.apm.core.transfer.InvokerService;
import com.lubanops.apm.core.transfer.TransferInvokerService;
import com.lubanops.apm.core.utils.ReportDataBuilder;
import com.lubanops.apm.core.utils.SpanEventPoolImpl;
import com.lubanops.apm.integration.Constants;
import com.lubanops.apm.integration.access.Message;
import com.lubanops.apm.integration.access.MessageIdGenerator;
import com.lubanops.apm.integration.access.MessageWrapper;
import com.lubanops.apm.integration.access.inbound.EventDataBody;
import com.lubanops.apm.integration.access.inbound.EventDataRequest;
import com.lubanops.apm.integration.access.inbound.TailSampleEventDataRequest;
import com.lubanops.apm.integration.utils.JSON;
import com.lubanops.apm.offload.OffHeapCacheManager;
import com.lubanops.apm.offload.TokenBucketTask;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.ArrayUtils;

public class TraceReportServiceImpl
implements TraceReportService {
    private static final int MAX_SPAN_EVENT_COUNT = 10240;
    private static final long DEFAULT_SPAN_EVENT_LENGTH = 1000L;
    private static final int onlineQueueUpperThreshold = 100;
    private static final int offlineQueueUpperThreshold = 50;
    private static final String SPAN_EVENT_DATA_TYPE = "SpanEventData";
    private static final ArrayBlockingQueue<SpanEvent> SPAN_EVENT_DATA_QUEUE = new ArrayBlockingQueue(10240);
    private static final ArrayBlockingQueue<SpanEvent> SPAN_EVENT_CACHE_QUEUE = new ArrayBlockingQueue(10240);
    private static final ArrayBlockingQueue<Byte[]> OFFHEAP_QUEUE = new ArrayBlockingQueue(10240);
    private static final Logger LOGGER = LogFactory.getLogger();
    private InvokerService invokerService = TransferInvokerService.getInstance();
    AtomicLong spanOffer = new AtomicLong(0L);
    AtomicLong span_event_data_count = new AtomicLong(0L);
    AtomicLong span_event_cache_count = new AtomicLong(0L);
    AtomicLong span_event_drop_count = new AtomicLong(0L);
    AtomicLong total_send_span_count = new AtomicLong(0L);
    AtomicLong total_online_send_span_count = new AtomicLong(0L);
    AtomicLong total_offline_send_span_count = new AtomicLong(0L);
    AtomicLong succ_online_send_span_count = new AtomicLong(0L);
    AtomicLong failed_online_send_span_count = new AtomicLong(0L);
    AtomicLong succ_offline_send_span_count = new AtomicLong(0L);
    AtomicLong failed_offline_send_span_count = new AtomicLong(0L);
    private HarvestListener<APMCollector> harvestListener;
    private List<ServiceThread> threadList = new ArrayList<ServiceThread>();
    private boolean closed = false;
    private boolean hasException = Boolean.FALSE;
    private static final OffHeapCacheManager cache = new OffHeapCacheManager();
    private static volatile TraceReportServiceImpl INSTACE = new TraceReportServiceImpl();
    private ScheduledFuture<?> readQueueExecutor;

    public static TraceReportServiceImpl getInstance() {
        return INSTACE;
    }

    public TraceReportServiceImpl() {
        int threadCount = Math.max(AgentConfigManager.getEventThreadCount(), 1);
        for (int i = 0; i < threadCount; ++i) {
            SpanEventSendOnlineThread spanEventSendOnlineThread = new SpanEventSendOnlineThread();
            spanEventSendOnlineThread.start();
            this.threadList.add(spanEventSendOnlineThread);
        }
        if (AgentConfigManager.isOffHeapFileEnable()) {
            SpanEventCacheTask spanEventCacheTask = new SpanEventCacheTask();
            spanEventCacheTask.start();
            this.threadList.add(spanEventCacheTask);
            SpanEventSendOfflineThread spanEventSendOfflineThread = new SpanEventSendOfflineThread();
            spanEventSendOfflineThread.start();
            this.threadList.add(spanEventSendOfflineThread);
            this.initCacheReadThread();
        }
        this.harvestListener = new HarvestListener<APMCollector>(){

            public void onHarvest(APMCollector collector, long time) {
                collector.monitorQueueSize((long)SPAN_EVENT_DATA_QUEUE.size(), AgentUtils.getObjectSize((Object)SPAN_EVENT_DATA_QUEUE));
            }
        };
        APMCollector.INSTANCE.listenHarvest(this.harvestListener);
        TokenBucketTask.getInstance().initInfoThread();
        if (AgentConfigManager.isTraceSendLog()) {
            this.initInfoThread();
        }
    }

    public void dispose() throws ApmRuntimeException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        int timeout = 1000;
        if (timeout > 0) {
            long start = System.currentTimeMillis();
            while (SPAN_EVENT_DATA_QUEUE.isEmpty() && System.currentTimeMillis() - start < (long)timeout) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                }
            }
        }
        SPAN_EVENT_DATA_QUEUE.clear();
        for (ServiceThread spanEventSendThread : this.threadList) {
            spanEventSendThread.shutdown(true);
        }
        this.threadList.clear();
    }

    public void offerEvent(SpanEvent spanEvent) {
        if (spanEvent == null) {
            return;
        }
        this.buildSpanEventIdentityTags(spanEvent);
        this.spanOffer.incrementAndGet();
        boolean success = SPAN_EVENT_DATA_QUEUE.offer(spanEvent);
        if (!success) {
            LOGGER.info("SPAN_EVENT_DATA_QUEUE offer full size " + SPAN_EVENT_DATA_QUEUE.size());
        }
        if (success) {
            this.span_event_data_count.incrementAndGet();
        } else if (AgentConfigManager.isOffHeapFileEnable() && (success = SPAN_EVENT_CACHE_QUEUE.offer(spanEvent))) {
            this.span_event_cache_count.incrementAndGet();
        }
        if (!success) {
            this.span_event_drop_count.incrementAndGet();
            APMCollector.onDiscard((String)SPAN_EVENT_DATA_TYPE, (long)1000L);
        } else {
            APMCollector.onStart((String)SPAN_EVENT_DATA_TYPE, (int)SPAN_EVENT_DATA_QUEUE.size());
        }
    }

    private SpanEvent buildSpanEventIdentityTags(SpanEvent spanEvent) {
        if (AgentConfigManager.isDrap() && "1".equals(spanEvent.getEventId()) && !"run()".equals(spanEvent.getSource())) {
            spanEvent.addTag("CAS_APPLICATION_NAME", SSConfigManager.getSsBizName());
            spanEvent.addTag("CAS_SUBAPPLICATION_NAME", SSConfigManager.getSsSubBizName());
            spanEvent.addTag("CAS_COMPONENT_NAME", SSConfigManager.getSsAppName());
            spanEvent.addTag("CAS_ENVIRONMENT_NAME", SSConfigManager.getSsEnvName());
            spanEvent.addTag("CAS_DEPLOYCELL_NAME", SSConfigManager.getSsDeployCellName());
            spanEvent.addTag("CAS_LOGICCELL_NAME", SSConfigManager.getSsLogicCellName());
            spanEvent.addTag("CAS_INSTANCE_NAME", SSConfigManager.getSsInstanceName());
            spanEvent.addTag("CAS_ENVIRONMENTGROUP_NAME", SSConfigManager.getSsEnvironmentGroupName());
            spanEvent.addTag("CAS_APPLICATION_ID", SSConfigManager.getSsBizId());
            spanEvent.addTag("CAS_SUBAPPLICATION_ID", SSConfigManager.getSsSubBizId());
            spanEvent.addTag("CAS_COMPONENT_ID", SSConfigManager.getSsAppId());
            spanEvent.addTag("CAS_ENVIRONMENT_ID", SSConfigManager.getSsEnvId());
            spanEvent.addTag("CAS_DEPLOYCELL_ID", SSConfigManager.getSsDeployCellId());
            spanEvent.addTag("CAS_LOGICCELL_ID", SSConfigManager.getSsLogicCellId());
            spanEvent.addTag("CAS_INSTANCE_ID", SSConfigManager.getSsInstanceId());
            spanEvent.addTag("CAS_ENVIRONMENTGROUP_ID", SSConfigManager.getSsEnvironmentGroupId());
            spanEvent.addTag("CAS_ENVIRONMENTGROUP_TYPE", SSConfigManager.getSsEnvironmentGroupType());
            spanEvent.addTag("CAS_AZ_NAME", SSConfigManager.getSsAzName());
        }
        return spanEvent;
    }

    private void initCacheReadThread() {
        if (this.readQueueExecutor != null) {
            this.readQueueExecutor.cancel(true);
        }
        this.readQueueExecutor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("APM-cachedCleaner", true)).scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (!cache.canRead()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                    }
                    return;
                }
                for (int i = 0; i < AgentConfigManager.getOffHeapReadBatchSize(); ++i) {
                    Byte[] serializedSpanEvent = null;
                    try {
                        serializedSpanEvent = cache.read();
                        if (serializedSpanEvent != null) {
                            OFFHEAP_QUEUE.put(serializedSpanEvent);
                        }
                        if (cache.canRead()) continue;
                        break;
                    }
                    catch (Exception e) {
                        if (serializedSpanEvent != null) {
                            APMCollector.onThrowable((String)TraceReportServiceImpl.SPAN_EVENT_DATA_TYPE, (long)serializedSpanEvent.length, (Throwable)e);
                        }
                        LOGGER.info("APM-cachedCleaner failed to put span event ,error message:" + e.getMessage() + ",type:" + e.getClass().getName() + e);
                    }
                }
            }
        }, 50L, 1L, TimeUnit.MILLISECONDS);
    }

    private void initInfoThread() {
        Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("APM-reported", true)).scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                StringBuilder result = new StringBuilder(100);
                result.append("spanOffer ").append(TraceReportServiceImpl.this.spanOffer.get()).append("\n").append("span_event_data_count ").append(TraceReportServiceImpl.this.span_event_data_count.get()).append("\n").append("span_event_cache_count ").append(TraceReportServiceImpl.this.span_event_cache_count.get()).append("\n").append("span_event_drop_count ").append(TraceReportServiceImpl.this.span_event_drop_count.get()).append("\n").append("total_send_span_count ").append(TraceReportServiceImpl.this.total_send_span_count.get()).append("\n").append("total_online_send_span_count ").append(TraceReportServiceImpl.this.total_online_send_span_count.get()).append("\n").append("total_offline_send_span_count ").append(TraceReportServiceImpl.this.total_offline_send_span_count.get()).append("\n").append("succ_online_send_span_count ").append(TraceReportServiceImpl.this.succ_online_send_span_count.get()).append("\n").append("failed_online_send_span_count ").append(TraceReportServiceImpl.this.failed_online_send_span_count.get()).append("\n").append("succ_offline_send_span_count ").append(TraceReportServiceImpl.this.succ_offline_send_span_count.get()).append("\n").append("failed_offline_send_span_count ").append(TraceReportServiceImpl.this.failed_offline_send_span_count.get()).append("\n").append("SPAN_EVENT_DATA_QUEUE ").append(SPAN_EVENT_DATA_QUEUE.size()).append("\n").append("SPAN_EVENT_CACHE_QUEUE ").append(SPAN_EVENT_CACHE_QUEUE.size()).append("\n").append("OFFHEAP_QUEUE ").append(OFFHEAP_QUEUE.size()).append("\n").append("tokens ").append(TokenBucket.getInstance().size()).append("\n").append("cpu_ratio ").append(String.format("%.2f", Stats.getCpuRatio()));
                System.out.println(result + "\n-------------\n");
            }
        }, 100L, 10000L, TimeUnit.MILLISECONDS);
    }

    public class SpanEventSendOnlineThread
    extends ServiceThread {
        Message msg;
        private EventDataRequest request;
        private long length;

        public SpanEventSendOnlineThread() {
            super(SpanEventSendOnlineThread.class.getSimpleName());
            this.msg = new Message();
        }

        @Override
        public void run() {
            LOGGER.info("[TRACE REPORTER]reporter start.");
            while (!this.isStopped()) {
                this.report();
            }
            LOGGER.info("[TRACE REPORTER]reporter stop.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean report() {
            long endTime = 0L;
            long startTime = 0L;
            SpanEvent spanEvent = null;
            try {
                if (!TraceReportServiceImpl.this.invokerService.isTraceSendEnable(100)) {
                    try {
                        LOGGER.info("SPAN_EVENT_DATA_QUEUE size : " + SPAN_EVENT_DATA_QUEUE.size());
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                    }
                    boolean e = true;
                    return e;
                }
                spanEvent = (SpanEvent)SPAN_EVENT_DATA_QUEUE.take();
                TraceReportServiceImpl.this.total_send_span_count.incrementAndGet();
                TraceReportServiceImpl.this.total_online_send_span_count.incrementAndGet();
                startTime = System.currentTimeMillis();
                this.request = spanEvent.hasSamplingPolicy() ? new TailSampleEventDataRequest(this.msg, spanEvent.getTraceId() + "TS") : new EventDataRequest(this.msg);
                this.request.setMessageId(MessageIdGenerator.generateMessageId());
                this.request.setHeader(ReportDataBuilder.buildEventDataHeader());
                this.request.getHeader().setNeedResponse(false);
                EventDataBody eventDataBody = ReportDataBuilder.buildEventDataBody(spanEvent);
                this.request.setBody(eventDataBody);
                this.length = this.request.getBodyBytes().length;
                if (this.length > 1000000L) {
                    LOGGER.log(Level.SEVERE, "data too big:" + this.request.getBodyString().substring(0, 1000));
                    HashMap<String, String> bodyMap = new HashMap<String, String>();
                    bodyMap.put("msg", "data more than 1M, and has discarded");
                    eventDataBody.setTags(bodyMap);
                    this.length = eventDataBody.toString().getBytes().length;
                }
                this.sendSpanEvent();
            }
            catch (Throwable e) {
                Level level = Level.SEVERE;
                if (TraceReportServiceImpl.this.hasException) {
                    level = Level.FINE;
                }
                LOGGER.log(level, "failed to send data,error message:" + e.getMessage() + ",type:" + e.getClass().getName(), e);
                APMCollector.onThrowable((String)TraceReportServiceImpl.SPAN_EVENT_DATA_TYPE, (long)this.length, (Throwable)e);
                TraceReportServiceImpl.this.hasException = true;
            }
            finally {
                if (startTime > 0L) {
                    endTime = System.currentTimeMillis();
                    APMCollector.onFinally((String)TraceReportServiceImpl.SPAN_EVENT_DATA_TYPE, (long)(endTime - startTime));
                }
                if (spanEvent != null) {
                    SpanEventPoolImpl.getInstance().recycle(spanEvent);
                }
            }
            return true;
        }

        public void sendSpanEvent() throws ConnectionException, IOException {
            TraceReportServiceImpl.this.succ_online_send_span_count.incrementAndGet();
            TraceReportServiceImpl.this.invokerService.sendDataReport((MessageWrapper)this.request);
            APMCollector.onSuccess((String)TraceReportServiceImpl.SPAN_EVENT_DATA_TYPE, (long)this.length);
        }

        @Override
        public String getServiceName() {
            return TraceReportServiceImpl.class.getSimpleName();
        }

        @Override
        protected void onWaitEnd() {
        }
    }

    public class SpanEventCacheTask
    extends ServiceThread {
        public SpanEventCacheTask() {
            super(SpanEventCacheTask.class.getSimpleName());
        }

        @Override
        public String getServiceName() {
            return SpanEventCacheTask.class.getSimpleName();
        }

        @Override
        protected void onWaitEnd() {
        }

        private byte[] convertToByteArr(SpanEvent event) {
            EventDataBody eventDataBody = ReportDataBuilder.buildEventDataBody(event);
            Map tag = eventDataBody.getTags();
            Object mysqlResult = tag.get("mysqlResult");
            if (mysqlResult != null) {
                tag.put("mysqlResult", JSON.toJSONString(mysqlResult));
            }
            byte[] buffer = JSON.toJSONBytes((Object)eventDataBody);
            String traceId = event.getTraceId() + (event.hasSamplingPolicy() ? "TS" : "");
            int event_serialized_size = 2 + traceId.length() + buffer.length;
            return ByteBuffer.allocate(event_serialized_size).putShort((short)traceId.length()).put(traceId.getBytes()).put(buffer).array();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOGGER.info("[TRACE CONVERTER] start.");
            while (!this.isStopped()) {
                SpanEvent spanEvent = null;
                byte[] arr = null;
                try {
                    spanEvent = (SpanEvent)SPAN_EVENT_CACHE_QUEUE.take();
                    arr = this.convertToByteArr(spanEvent);
                    boolean success = cache.write(arr);
                    if (success) continue;
                    APMCollector.onDiscard((String)TraceReportServiceImpl.SPAN_EVENT_DATA_TYPE, (long)arr.length);
                    LogFactory.getLogger().warningFullQueue("spanevent data queue is full,data discarded:" + spanEvent.toString());
                }
                catch (Throwable e) {
                    LOGGER.log(Level.SEVERE, "Failed to convert span event ,error message:" + e.getMessage() + ",type:" + e.getClass().getName(), e);
                    if (arr == null) continue;
                    APMCollector.onThrowable((String)TraceReportServiceImpl.SPAN_EVENT_DATA_TYPE, (long)arr.length, (Throwable)e);
                }
                finally {
                    if (spanEvent == null) continue;
                    SpanEventPoolImpl.getInstance().recycle(spanEvent);
                }
            }
            LOGGER.info("[TRACE CONVERTER] end.");
        }
    }

    public class SpanEventSendOfflineThread
    extends ServiceThread {
        Message msg;
        private EventDataRequest request;
        private long length;

        public SpanEventSendOfflineThread() {
            super(SpanEventSendOfflineThread.class.getSimpleName());
            this.msg = new Message();
        }

        @Override
        public void run() {
            LOGGER.info("[TRACE REPORTER]reporter start.");
            while (!this.isStopped()) {
                this.report();
            }
            LOGGER.info("[TRACE REPORTER]reporter stop.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean report() {
            long endTime = 0L;
            long startTime = 0L;
            try {
                if (!TraceReportServiceImpl.this.invokerService.isTraceSendEnable(50)) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                    }
                    boolean e = true;
                    return e;
                }
                Byte[] arr = (Byte[])OFFHEAP_QUEUE.take();
                TraceReportServiceImpl.this.total_send_span_count.incrementAndGet();
                TraceReportServiceImpl.this.total_offline_send_span_count.incrementAndGet();
                startTime = System.currentTimeMillis();
                ByteBuffer traceBuffer = ByteBuffer.wrap(ArrayUtils.toPrimitive((Byte[])arr));
                short traceIdSize = traceBuffer.getShort();
                String traceId = new String(traceBuffer.array(), 2, (int)traceIdSize, Constants.DEFAULT_CHARSET);
                this.request = traceId.endsWith("TS") ? new TailSampleEventDataRequest(this.msg, traceId) : new EventDataRequest(this.msg);
                this.request.setMessageId(MessageIdGenerator.generateMessageId());
                this.request.setHeader(ReportDataBuilder.buildEventDataHeader());
                this.request.getHeader().setNeedResponse(false);
                ((Buffer)traceBuffer).position(traceIdSize + 2);
                byte[] body = new byte[traceBuffer.remaining()];
                traceBuffer.get(body);
                this.request.setBodyBytes(body);
                this.length = this.request.getBodyBytes().length;
                if (this.length > 1000000L) {
                    EventDataBody eventDataBody = new EventDataBody();
                    LOGGER.log(Level.SEVERE, "data too big:" + this.request.getBodyString().substring(0, 1000));
                    HashMap<String, String> bodyMap = new HashMap<String, String>();
                    bodyMap.put("msg", "data more than 1M, and has discarded");
                    eventDataBody.setTags(bodyMap);
                    this.request.setBodyBytes(eventDataBody.toBytes());
                    this.length = eventDataBody.toString().getBytes().length;
                }
                this.sendSpanEvent();
            }
            catch (Throwable e) {
                Level level = Level.SEVERE;
                if (TraceReportServiceImpl.this.hasException) {
                    level = Level.FINE;
                }
                LOGGER.log(level, "failed to send data,error message:" + e.getMessage() + ",type:" + e.getClass().getName(), e);
                APMCollector.onThrowable((String)TraceReportServiceImpl.SPAN_EVENT_DATA_TYPE, (long)this.length, (Throwable)e);
                TraceReportServiceImpl.this.hasException = true;
            }
            finally {
                if (startTime > 0L) {
                    endTime = System.currentTimeMillis();
                    APMCollector.onFinally((String)TraceReportServiceImpl.SPAN_EVENT_DATA_TYPE, (long)(endTime - startTime));
                }
            }
            return true;
        }

        public void sendSpanEvent() throws ConnectionException, IOException {
            TraceReportServiceImpl.this.invokerService.sendDataReport((MessageWrapper)this.request);
            TraceReportServiceImpl.this.succ_offline_send_span_count.incrementAndGet();
            APMCollector.onSuccess((String)TraceReportServiceImpl.SPAN_EVENT_DATA_TYPE, (long)this.length);
        }

        @Override
        public String getServiceName() {
            return TraceReportServiceImpl.class.getSimpleName();
        }

        @Override
        protected void onWaitEnd() {
        }
    }
}

