/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.transformer;

import com.lubanops.apm.bootstrap.Listener;
import com.lubanops.apm.bootstrap.NoneNamedListener;
import com.lubanops.apm.bootstrap.commons.ConditionOnVersion;
import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.utils.FileUtils;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.core.transformer.NamedTransformer;
import com.lubanops.apm.core.transformer.NoneNamedTransformer;
import com.lubanops.apm.core.transformer.TransformerManager;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.jar.JarFile;

public class Transformer
implements ClassFileTransformer {
    private static final Logger LOG = LogFactory.getLogger();
    private static Map<String, Listener> listenerMap = new HashMap<String, Listener>();
    private static List<NoneNamedListener> listenerList = new ArrayList<NoneNamedListener>();
    private static List<Listener> toInitListenerList = new ArrayList<Listener>();
    private URLClassLoader pluginClassLoader;

    public Transformer(URLClassLoader pluginClassLoader) {
        this.pluginClassLoader = pluginClassLoader;
        try {
            ServiceLoader<Listener> listeners = ServiceLoader.load(Listener.class, pluginClassLoader);
            for (Listener listener : listeners) {
                Set set = listener.getClasses();
                if (set != null) {
                    for (String className : set) {
                        listenerMap.put(className, listener);
                    }
                    continue;
                }
                toInitListenerList.add(listener);
            }
            ServiceLoader<NoneNamedListener> noneNamedListeners = ServiceLoader.load(NoneNamedListener.class, pluginClassLoader);
            for (NoneNamedListener listener : noneNamedListeners) {
                JarFile pluginJar = new JarFile(FileUtils.getInterceptorFile((ClassLoader)pluginClassLoader, (String)listener.getInterceptor()));
                if (listener.appendBootstrapClassLoader()) {
                    TransformerManager.getInstrumentation().appendToBootstrapClassLoaderSearch(pluginJar);
                }
                listenerList.add(listener);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "get listeners failed", (Throwable)e);
        }
    }

    private boolean isNeedTransform(String className, ClassLoader loader) {
        if (className == null || className.startsWith("com/lubanops/apm/bootstrap") || className.startsWith("com/lubanops/apm/plugin") || this.pluginClassLoader.equals(loader)) {
            return false;
        }
        return !className.startsWith("org/apache/skywalking") && !className.startsWith("net/bytebuddy") && !className.startsWith("org/objectweb/asm") && !className.startsWith("org/aspectj") && (!className.startsWith("com/alibaba/ttl") || "com/alibaba/ttl/TtlRunnable".equals(className)) && !className.startsWith("com/baidu/openrasp") && !className.startsWith("com/navercorp/pinpoint") && !className.startsWith("com/huawei/mars") && !className.startsWith("com/huawei/l11") && !className.startsWith("com/huawei/devcloud/stresstest");
    }

    private boolean isNeedNoneNamedTransform(String className) {
        return !className.startsWith("sun/") && !className.startsWith("org/w3c/dom/") && !className.startsWith("org/omg/") && !className.startsWith("com/sun/") && !className.startsWith("java/") && !className.startsWith("javax/") && !className.contains("Lambda");
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (AgentConfigManager.isClosed()) {
            LogFactory.getLogger().log(Level.FINE, className + " not transform");
            return classfileBuffer;
        }
        try {
            if (!this.isNeedTransform(className, loader)) {
                return classfileBuffer;
            }
            if (loader == null || !"com.lubanops.apm.premain.classloader.LopsUrlClassLoader".equals(loader.getClass().getName()) || className.equals("com/taobao/arthas/core/util/ArthasBanner")) {
                Listener listener = listenerMap.get(className);
                if (listener != null) {
                    String version = Util.getJarVersionFromProtectionDomain((ProtectionDomain)protectionDomain);
                    if (!new VersionChecker(version, listener).check()) {
                        return classfileBuffer;
                    }
                    listener.addTag();
                    return new NamedTransformer(this.pluginClassLoader).transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer, listener);
                }
                if (!this.isNeedNoneNamedTransform(className)) {
                    return classfileBuffer;
                }
                return new NoneNamedTransformer(this.pluginClassLoader).transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer, listenerList);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Interceptor failed for " + className, (Throwable)e);
        }
        return classfileBuffer;
    }

    public static void initListener() {
        for (NoneNamedListener noneNamedListener : listenerList) {
            noneNamedListener.init();
        }
        for (Listener listener : listenerMap.values()) {
            listener.init();
        }
        for (Listener listener : toInitListenerList) {
            listener.init();
        }
    }

    public class VersionChecker {
        private String version;
        private Listener listener;

        public VersionChecker(String version, Listener listener) {
            this.version = version;
            this.listener = listener;
        }

        public boolean check() {
            ConditionOnVersion conditionOnVersion = this.listener.getClass().getAnnotation(ConditionOnVersion.class);
            if (null == conditionOnVersion) {
                return true;
            }
            for (String definedVersion : conditionOnVersion.versions()) {
                if (!this.matchVersion(definedVersion, this.version)) continue;
                return true;
            }
            LOG.log(Level.INFO, String.format("[APM TRANSFORMER]transformer not trigger because version[%s] match miss.", this.version));
            return false;
        }

        public boolean matchVersion(String definedVersion, String packageName) {
            try {
                String[] regVersionArr = definedVersion.split("\\.");
                if (!StringUtils.isDigit((String)regVersionArr[0])) {
                    LOG.log(Level.SEVERE, String.format("[APM TRANSFORMER]bad condition on version defined[%s].", definedVersion));
                    return true;
                }
                int offset = packageName.indexOf(regVersionArr[0] + ".");
                if (offset < 0) {
                    return false;
                }
                for (int i = 0; i < regVersionArr.length; ++i) {
                    int startIndex = offset;
                    int endIndex = packageName.indexOf(".", offset);
                    if (endIndex <= startIndex) {
                        return false;
                    }
                    String matchSegStr = packageName.substring(startIndex, endIndex);
                    if (i == regVersionArr.length - 1 && !StringUtils.isDigit((String)matchSegStr)) {
                        endIndex = packageName.indexOf("-", offset);
                        matchSegStr = packageName.substring(startIndex, endIndex);
                    }
                    offset = endIndex + 1;
                    if (regVersionArr[i].equalsIgnoreCase("x") || regVersionArr[i].equals(matchSegStr)) continue;
                    return false;
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, String.format("[APM TRANSFORMER]matchVersion error occur [definedVersion:%s][packageName:%s].", definedVersion, packageName), (Throwable)e);
            }
            return true;
        }
    }
}

