/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.offload;

import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.core.utils.ReportDataBuilder;
import com.lubanops.apm.integration.access.inbound.EventDataBody;
import com.lubanops.apm.integration.utils.JSON;
import com.lubanops.apm.offload.GetAnswer;
import com.lubanops.apm.offload.OffHeapCache;
import com.lubanops.apm.offload.OfferAnswer;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class OffHeapCacheManager {
    ConcurrentLinkedDeque<OffHeapCache> offHeapCacheQueue = new ConcurrentLinkedDeque();
    ConcurrentLinkedQueue<OffHeapCache> readCacheQueue = new ConcurrentLinkedQueue();
    AtomicInteger cache_size = new AtomicInteger(0);
    AtomicInteger currentCacheFilesAmount = new AtomicInteger(0);

    public OffHeapCacheManager() {
        this.initCachesQueue(AgentConfigManager.getOffHeapFilesAmount());
    }

    public void initCachesQueue(int num) {
        try {
            for (int i = 0; i < num; ++i) {
                this.offHeapCacheQueue.push(new OffHeapCache(this.currentCacheFilesAmount.getAndIncrement()));
            }
        }
        catch (Exception e) {
            LogFactory.getLogger().severe("Failed to init to cache " + e.getMessage());
        }
    }

    public boolean write(byte[] arr) {
        if (this.offHeapCacheQueue.size() == 0) {
            if (this.addFiles()) {
                return this.write(arr);
            }
            LogFactory.getLogger().severe("Thread = [" + Thread.currentThread() + "] no cache to write");
            return false;
        }
        try {
            OffHeapCache cache = this.offHeapCacheQueue.pollFirst();
            if (cache == null) {
                LogFactory.getLogger().info("Thread = [" + Thread.currentThread() + "] no cache to write ,retry");
                return this.write(arr);
            }
            OfferAnswer answer = cache.offer(arr);
            if (answer.getNeedToWriteToNextCacheFile().booleanValue()) {
                this.readCacheQueue.add(cache);
                LogFactory.getLogger().info("Thread = [" + Thread.currentThread() + "] cache " + cache.index() + " is full size:" + cache.size() + "b SEND : Idle/Ready " + this.offHeapCacheQueue.size() + "/" + this.readCacheQueue.size());
                return this.write(arr);
            }
            if (answer.getStatus().booleanValue()) {
                this.cache_size.incrementAndGet();
                this.offHeapCacheQueue.offerFirst(cache);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LogFactory.getLogger().severe(" offer ERROR = [" + e.getMessage() + "]");
        }
        return false;
    }

    public Byte[] read() {
        if (!this.canRead()) {
            return null;
        }
        GetAnswer answer = this.readCacheQueue.peek().get();
        if (answer.getNeedToReadTFromNextCacheFile().booleanValue()) {
            OffHeapCache offHeapCache = this.readCacheQueue.poll();
            if (offHeapCache != null) {
                this.offHeapCacheQueue.addLast(offHeapCache.init());
            }
            LogFactory.getLogger().info("Thread = [" + Thread.currentThread() + "] after READ return cache id " + offHeapCache.index() + " : Idle/Ready " + this.offHeapCacheQueue.size() + "/" + this.readCacheQueue.size());
        }
        if (answer.getArr() != null) {
            this.cache_size.decrementAndGet();
            return answer.getArr();
        }
        return null;
    }

    public boolean canRead() {
        return !this.readCacheQueue.isEmpty();
    }

    public long size() {
        return this.cache_size.get();
    }

    private synchronized boolean addFiles() {
        if (this.currentCacheFilesAmount.get() >= 10 * AgentConfigManager.getOffHeapFilesAmount()) {
            return false;
        }
        LogFactory.getLogger().info("ADDING additional 10 files !!!");
        this.initCachesQueue(10);
        return true;
    }

    public byte[] convertToByteArr(SpanEvent event) {
        EventDataBody eventDataBody = ReportDataBuilder.buildEventDataBody(event);
        Map tag = eventDataBody.getTags();
        Object mysqlResult = tag.get("mysqlResult");
        if (mysqlResult != null) {
            tag.put("mysqlResult", JSON.toJSONString(mysqlResult));
        }
        return JSON.toJSONBytes((Object)eventDataBody);
    }
}

