/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mysql5.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlTrace;
import com.lubanops.apm.plugin.mysql5.interceptor.PreparedStatementInteceptor;
import com.lubanops.apm.plugin.mysql5.utils.Mysql5Utils;
import com.mysql.jdbc.ResultSetImpl;
import com.mysql.jdbc.StatementImpl;

public class StatementExecuteQueryInterceptor
implements Interceptor {
    public Object[] onStart(Object mysql5Object, Object[] args, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable() && !Mysql5Utils.isConnecting()) {
                StatementImpl statement = (StatementImpl)mysql5Object;
                String originSql = (String)args[0];
                if (this.isReadOnlySql(originSql)) {
                    return null;
                }
                Integer id = PreparedStatementInteceptor.getConnectionId(statement);
                PreparedStatementInteceptor.onStart(originSql, id);
                MysqlTrace.onStart((String)className, (String)methodName, (String)originSql, (String)originSql, (Integer)id);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                String sql = (String)args[0];
                if (this.isReadOnlySql(sql)) {
                    return;
                }
                PreparedStatementInteceptor.onError(sql, e);
                MysqlTrace.onError((Throwable)e);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "StatementExecuteQueryInterceptor onError", (Throwable)ex);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable() && !Mysql5Utils.isConnecting()) {
                String sql = (String)args[0];
                if (this.isReadOnlySql(sql)) {
                    return;
                }
                ResultSetImpl resultSet = (ResultSetImpl)result;
                int readCount = 0;
                if (resultSet != null) {
                    readCount = Integer.valueOf(String.valueOf(resultSet.getUpdateCount()));
                }
                MysqlCollector.onFinally((int)0, (int)readCount);
                if (result != null && result instanceof TransformAccess) {
                    MysqlTrace.onFinally((int)0, (int)readCount, (TransformAccess)((TransformAccess)result));
                } else {
                    MysqlTrace.onFinally((int)0, (int)readCount, null);
                }
                MysqlCollector.onConnectionEnd((String)sql, (int)0, (int)readCount);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    private boolean isReadOnlySql(String sql) {
        return "select @@session.transaction_read_only".equals(sql) || "select @@session.tx_read_only".equals(sql);
    }
}

