/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.cassandra3.collector;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultExceptionAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultVersionAggregator;
import com.lubanops.apm.plugin.cassandra3.apreload.CassandraStats;
import com.lubanops.apm.plugin.cassandra3.collector.CassandraClusterAggregator;
import com.lubanops.apm.plugin.cassandra3.collector.CassandraConnectionAggregator;
import com.lubanops.apm.plugin.cassandra3.collector.CassandraCqlAggregator;
import com.lubanops.apm.plugin.cassandra3.collector.CassandraNodeAggregator;
import java.util.Map;

public class CassandraCollector
extends Collector {
    public static final CassandraCollector INSTANCE = new CassandraCollector();
    private static final CassandraCqlAggregator CQL_AGGREGATOR = new CassandraCqlAggregator();
    private static final CassandraNodeAggregator NODE_AGGREGATOR = new CassandraNodeAggregator();
    private static final CassandraClusterAggregator CLUSTER_AGGREGATOR = new CassandraClusterAggregator();
    private static final CassandraConnectionAggregator CONNECTION_AGGREGATOR = new CassandraConnectionAggregator();
    private static final DefaultExceptionAggregator EXCEPTION_AGGREGATOR = new DefaultExceptionAggregator();
    public static final DefaultVersionAggregator VERSION_AGGREGATOR = new DefaultVersionAggregator();

    public void parseParameter(Map<String, String> parameters) {
        CQL_AGGREGATOR.parseParameters(parameters);
        CONNECTION_AGGREGATOR.parseParameters(parameters);
    }

    public static Map<String, Object> onStartAsync(String cql) {
        return CQL_AGGREGATOR.onStartAsync(cql);
    }

    public static Map<String, Object> onErrorAsync(Map<String, Object> context, String errorTraceId) {
        return CQL_AGGREGATOR.onErrorAsync(context, errorTraceId);
    }

    public static void onFinallyAsync(Map<String, Object> context, String traceId) {
        CQL_AGGREGATOR.onFinallyAsync(context, traceId);
    }

    public static void incrementQueryCountAsync(Map<String, Object> context, long count) {
        CQL_AGGREGATOR.incrementQueryCountAsync(context, count);
    }

    public static Map<String, Object> onNodeStartAsync(String node) {
        return NODE_AGGREGATOR.onStartAsync(node);
    }

    public static void onNodeErrorAsync(Map<String, Object> context, String errorTraceId) {
        NODE_AGGREGATOR.onErrorAsync(context, errorTraceId);
    }

    public static void onNodeFinallyAsync(Map<String, Object> context, String traceId) {
        NODE_AGGREGATOR.onFinallyAsync(context, traceId);
    }

    public static Map<String, Object> onClusterStartAsync(String cluster) {
        return CLUSTER_AGGREGATOR.onStartAsync(cluster);
    }

    public static Map<String, Object> onClusterErrorAsync(Map<String, Object> context, String traceId) {
        return CLUSTER_AGGREGATOR.onErrorAsync(context, traceId);
    }

    public static void onClusterFinallyAsync(Map<String, Object> context, String traceId) {
        CLUSTER_AGGREGATOR.onFinallyAsync(context, traceId);
    }

    public static Map<String, Object> onConnectionStartAsync(String host) {
        return CONNECTION_AGGREGATOR.onStartAsync(host);
    }

    public static void onConnectionErrorAsync(CassandraStats stats, String errorTraceId) {
        CONNECTION_AGGREGATOR.onErrorAsync(stats, errorTraceId);
    }

    public static void onConnectionFinallyAsync(Long startTime, CassandraStats stats, String traceId) {
        CONNECTION_AGGREGATOR.onFinallyAsync(startTime, stats, traceId);
    }

    public static void onException(Throwable throwable) {
        EXCEPTION_AGGREGATOR.onThrowable(throwable);
    }

    public static void setDriverVersion(String version) {
        VERSION_AGGREGATOR.setVersion(version);
    }

    public static int getTimeSpanThreshold() {
        return CONNECTION_AGGREGATOR.getTimeSpanThreshold();
    }

    public String getCollectorName() {
        return "Cassandra";
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)CQL_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)NODE_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)CLUSTER_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)CONNECTION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)EXCEPTION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)VERSION_AGGREGATOR);
        INSTANCE.register();
    }
}

