/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.hikari.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.connectionpool.ConnectionPoolUtils;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.plugin.hikari.collector.HikariCollector;
import com.zaxxer.hikari.pool.HikariPool;
import java.security.ProtectionDomain;

public class GetConnectionInterceptor
implements Interceptor {
    private static final String HIKARI_BEFORE_GET_CONNECTION = "beforeGetConnection";
    private static final String HIKARI_AFTER_GET_CONNECTION = "AfterGetConnection";
    private static final String ACTIVE_COUNT = "activeCount";
    private static final String POOLING_COUNT = "poolingCount";
    private static final String WAIT_THREAD_COUNT = "waitThreadCount";

    public GetConnectionInterceptor() {
        HikariCollector.setDriverVersion(Util.getJarVersionFromProtectionDomain((ProtectionDomain)HikariPool.class.getProtectionDomain()));
    }

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (HikariCollector.INSTANCE.isEnable()) {
                HikariPool pool = (HikariPool)object;
                int activeConnections = pool.getActiveConnections();
                int totalConnections = pool.getTotalConnections();
                int awaitingConnection = pool.getThreadsAwaitingConnection();
                HikariCollector.INSTANCE.setCounts(activeConnections, totalConnections, awaitingConnection);
                HikariCollector.onStart(pool);
                TraceCollector.onStart((String)className, (String)methodName, (String)"Hikari");
            }
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "GetConnectionInterceptor onstart failed", (Throwable)e);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (HikariCollector.INSTANCE.isEnable()) {
                HikariCollector.onThrowable(e);
                ConnectionPoolUtils.setErrorMsg((Throwable)e);
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "GetConnectionInterceptor onError failed", (Throwable)e1);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (HikariCollector.INSTANCE.isEnable()) {
                HikariCollector.onFinally();
                SpanEvent spanEvent = TraceCollector.onFinally((boolean)false);
                if (spanEvent != null && (spanEvent.getChildrenEventCount() > 0 || spanEvent.getTimeUsed() >= (long)HikariCollector.INSTANCE.getTimeSpanThreshold() || spanEvent.getHasError())) {
                    if (HikariCollector.INSTANCE.isGetPoolInfo()) {
                        Integer activeCountBefore = HikariCollector.INSTANCE.getActiveCount();
                        Integer poolingCountBefore = HikariCollector.INSTANCE.getPoolingCount();
                        Integer waitThreadCountBefore = HikariCollector.INSTANCE.getWaitThreadCount();
                        HikariCollector.INSTANCE.clearCounts();
                        if (activeCountBefore != null && poolingCountBefore != null && waitThreadCountBefore != null) {
                            HikariPool pool = (HikariPool)object;
                            int activeCountAfter = pool.getActiveConnections();
                            int poolingCountAfter = pool.getTotalConnections();
                            int waitThreadCountAfter = pool.getThreadsAwaitingConnection();
                            String hikariBeforeContext = "activeCount: " + activeCountBefore + "\n" + POOLING_COUNT + ": " + poolingCountBefore + "\n" + WAIT_THREAD_COUNT + ": " + waitThreadCountBefore;
                            String hikariAfterContext = "activeCount: " + activeCountAfter + "\n" + POOLING_COUNT + ": " + poolingCountAfter + "\n" + WAIT_THREAD_COUNT + ": " + waitThreadCountAfter;
                            spanEvent.addTag(HIKARI_BEFORE_GET_CONNECTION, hikariBeforeContext);
                            spanEvent.addTag(HIKARI_AFTER_GET_CONNECTION, hikariAfterContext);
                        }
                    }
                    TraceCollector.sendSpanEvent((SpanEvent)spanEvent);
                }
            }
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e);
        }
    }
}

