/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.core;

import com.huawei.gaussdb.jdbc.core.Query;
import com.huawei.gaussdb.jdbc.util.CanEstimateSize;
import java.util.ArrayList;

public class CachedQuery
implements CanEstimateSize {
    public final Object key;
    public final Query query;
    public final boolean isFunction;
    public final boolean isACompatibilityFunction;
    private int executeCount;
    private final ArrayList<Query> rewriteQueries = new ArrayList();

    public CachedQuery(Object key, Query query, boolean isFunction, boolean isACompatibilityFunction) {
        assert (key instanceof String || key instanceof CanEstimateSize) : "CachedQuery.key should either be String or implement CanEstimateSize. Actual class is " + key.getClass();
        this.key = key;
        this.query = query;
        this.isFunction = isFunction;
        this.isACompatibilityFunction = isACompatibilityFunction;
        this.query.setIsFunction(isFunction);
    }

    public void increaseExecuteCount() {
        if (this.executeCount < Integer.MAX_VALUE) {
            ++this.executeCount;
        }
    }

    public void increaseExecuteCount(int inc) {
        int newValue = this.executeCount + inc;
        if (newValue > 0) {
            this.executeCount = newValue;
        }
    }

    public int getExecuteCount() {
        return this.executeCount;
    }

    @Override
    public long getSize() {
        long queryLength = this.key instanceof String ? (long)((String)this.key).length() * 2L : ((CanEstimateSize)this.key).getSize();
        return queryLength * 2L + 100L;
    }

    public void addRewriteQueries(Query query) {
        this.rewriteQueries.add(query);
    }

    public ArrayList<Query> getRewriteQueries() {
        return this.rewriteQueries;
    }

    public boolean isRewriteQueriesEmpty() {
        return this.rewriteQueries.isEmpty();
    }

    public void clearRewriteQueries() {
        if (this.rewriteQueries.isEmpty()) {
            return;
        }
        this.rewriteQueries.clear();
    }

    public String toString() {
        return "CachedQuery{executeCount=" + this.executeCount + ", query=" + this.query + ", isFunction=" + this.isFunction + '}';
    }
}

