/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc;

import com.huawei.gaussdb.jdbc.CompatibilityModeEnum;
import com.huawei.gaussdb.jdbc.core.Utils;
import com.huawei.gaussdb.jdbc.util.GT;
import com.huawei.gaussdb.jdbc.util.PSQLException;
import com.huawei.gaussdb.jdbc.util.PSQLState;
import java.sql.SQLException;
import java.sql.Savepoint;

public class PSQLSavepoint
implements Savepoint {
    private boolean _isValid = true;
    private boolean _isNamed;
    private int _id;
    private String _name;
    private CompatibilityModeEnum mode;

    public PSQLSavepoint(int id) {
        this._isNamed = false;
        this._id = id;
    }

    public PSQLSavepoint(String name) {
        this._isNamed = true;
        this._name = name;
    }

    public CompatibilityModeEnum getMode() {
        return this.mode;
    }

    public void setMode(CompatibilityModeEnum mode) {
        this.mode = mode;
    }

    @Override
    public int getSavepointId() throws SQLException {
        if (!this._isValid) {
            throw new PSQLException(GT.tr("THE_SAVEPOINT_HAS_BEEN_RELEASED", new Object[0]), PSQLState.INVALID_SAVEPOINT_SPECIFICATION);
        }
        if (this._isNamed) {
            throw new PSQLException(GT.tr("CAN_NOT_RETRIEVE_THE_EXISTED_SAVEPOINT", new Object[0]), PSQLState.WRONG_OBJECT_TYPE);
        }
        return this._id;
    }

    @Override
    public String getSavepointName() throws SQLException {
        if (!this._isValid) {
            throw new PSQLException(GT.tr("THE_SAVEPOINT_HAS_BEEN_RELEASED", new Object[0]), PSQLState.INVALID_SAVEPOINT_SPECIFICATION);
        }
        if (!this._isNamed) {
            throw new PSQLException(GT.tr("WRONG_OBJECT_TYPE", new Object[0]), PSQLState.WRONG_OBJECT_TYPE);
        }
        return this._name;
    }

    public void invalidate() {
        this._isValid = false;
    }

    public String getPGName() throws SQLException {
        if (!this._isValid) {
            throw new PSQLException(GT.tr("THE_SAVEPOINT_HAS_BEEN_RELEASED", new Object[0]), PSQLState.INVALID_SAVEPOINT_SPECIFICATION);
        }
        if (this._isNamed) {
            return Utils.escapeIdentifier(null, this._name, this.mode).toString();
        }
        return "JDBC_SAVEPOINT_" + this._id;
    }
}

