/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.alt.batch;

import com.huawei.gaussdb.jdbc.PGConnection;
import com.huawei.gaussdb.jdbc.jdbc.alt.batch.Function;
import com.huawei.gaussdb.jdbc.jdbc.alt.tac.TacReConnectInfo;
import com.huawei.gaussdb.jdbc.jdbc.alt.util.TacReConnectUtil;
import java.util.Objects;

public class QueryGucFunction
implements Function<PGConnection, TacReConnectInfo> {
    private final String altClusterId;

    public QueryGucFunction(String altClusterId) {
        this.altClusterId = altClusterId;
    }

    @Override
    public TacReConnectInfo apply(PGConnection pgConnection) {
        TacReConnectInfo tacReConnectInfo = new TacReConnectInfo();
        tacReConnectInfo.setAltClusterId(this.altClusterId);
        tacReConnectInfo.setPgConnection(pgConnection);
        tacReConnectInfo.setGucParams(TacReConnectUtil.queryGUCParams(pgConnection));
        return tacReConnectInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryGucFunction)) {
            return false;
        }
        QueryGucFunction that = (QueryGucFunction)o;
        return Objects.equals(this.altClusterId, that.altClusterId);
    }

    public int hashCode() {
        return Objects.hash(this.altClusterId);
    }

    public String toString() {
        return "QueryGucFunction{altClusterId='" + this.altClusterId + '\'' + '}';
    }
}

