/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.alt.batch;

import com.huawei.gaussdb.jdbc.Driver;
import com.huawei.gaussdb.jdbc.PGConnection;
import com.huawei.gaussdb.jdbc.PGProperty;
import com.huawei.gaussdb.jdbc.core.QueryExecutor;
import com.huawei.gaussdb.jdbc.core.v3.ConnectionFactoryImpl;
import com.huawei.gaussdb.jdbc.core.v3.QueryExecutorImpl;
import com.huawei.gaussdb.jdbc.jdbc.PgConnection;
import com.huawei.gaussdb.jdbc.jdbc.alt.batch.Function;
import com.huawei.gaussdb.jdbc.jdbc.alt.exception.ALTException;
import com.huawei.gaussdb.jdbc.jdbc.alt.fan.DBConnectionTracker;
import com.huawei.gaussdb.jdbc.jdbc.alt.tac.TacReConnectInfo;
import com.huawei.gaussdb.jdbc.jdbc.alt.util.LoggerUtil;
import com.huawei.gaussdb.jdbc.log.Log;
import com.huawei.gaussdb.jdbc.log.Logger;
import com.huawei.gaussdb.jdbc.util.HostSpec;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;

public class ReConnectFunction
implements Function<TacReConnectInfo, Boolean> {
    private static final Log LOGGER = Logger.getLogger(ReConnectFunction.class.getName());
    private final DBConnectionTracker dbConnectionTracker;

    public ReConnectFunction(DBConnectionTracker dbConnectionTracker) {
        this.dbConnectionTracker = dbConnectionTracker;
    }

    @Override
    public Boolean apply(TacReConnectInfo tacReConnectInfo) {
        String altClusterId = tacReConnectInfo.getAltClusterId();
        PGConnection pgConnection = tacReConnectInfo.getPgConnection();
        if (!(pgConnection instanceof PgConnection)) {
            return Boolean.FALSE;
        }
        PgConnection con = (PgConnection)pgConnection;
        Properties properties = new Properties();
        if (con.tacGetQueryExecutor() instanceof QueryExecutorImpl) {
            properties = ((QueryExecutorImpl)con.tacGetQueryExecutor()).getProps();
        }
        PGProperty.ALT_CLUSTER_ID.set(properties, altClusterId);
        try {
            QueryExecutor newQE = this.buildNewQueryExecutor(properties);
            QueryExecutor queryExecutor = con.tacGetQueryExecutor();
            queryExecutor.setSocketAddress(newQE.getSocketAddress());
            queryExecutor.setLanHostSpec(newQE.getLanHostSpec().getHost());
            queryExecutor.setPlannedPgStream(newQE.getPGStream());
            con.setSocketAddress(newQE.getSocketAddress());
            con.setGUCParamsInConnection(tacReConnectInfo.getGucParams());
        }
        catch (ALTException e) {
            LoggerUtil.warn(LOGGER, "ReConnect fail, The connection " + con.getSocketAddress() + " loses the ALT feature and becomes a normal connection.");
            con.setTacInValid(true);
        }
        this.dbConnectionTracker.addConnectionItem(con, properties);
        return Boolean.TRUE;
    }

    private QueryExecutor buildNewQueryExecutor(Properties properties) throws ALTException {
        Object[] urlHostSpecs = Driver.getURLHostSpecs(properties);
        String user = Driver.GetUser(properties);
        String database = Driver.GetDatabase(properties);
        try {
            QueryExecutor queryExecutor = ConnectionFactoryImpl.openConnection((HostSpec[])urlHostSpecs, user, database, properties);
            String lanHostSpec = ConnectionFactoryImpl.queryFanInfo(queryExecutor);
            queryExecutor.setLanHostSpec(lanHostSpec);
            this.dbConnectionTracker.recordIPMap(queryExecutor.getHostSpec(), queryExecutor.getLanHostSpec());
            return queryExecutor;
        }
        catch (SQLException sqlException) {
            LoggerUtil.warn(LOGGER, "Can't build new queryExecutor with DN : " + sqlException.getMessage());
        }
        catch (IOException e) {
            LoggerUtil.warn(LOGGER, "Can't queryFanInfo from database : " + e.getMessage());
        }
        throw new ALTException("can't build new queryExecutor : " + Arrays.toString(urlHostSpecs));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReConnectFunction)) {
            return false;
        }
        ReConnectFunction that = (ReConnectFunction)o;
        return Objects.equals(this.dbConnectionTracker, that.dbConnectionTracker);
    }

    public int hashCode() {
        return Objects.hash(this.dbConnectionTracker);
    }

    public String toString() {
        return "ReConnectFunction{, dbConnectionTracker=" + this.dbConnectionTracker + '}';
    }
}

