/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.alt.connection;

import com.huawei.gaussdb.jdbc.jdbc.alt.cluster.ALTContext;
import com.huawei.gaussdb.jdbc.jdbc.alt.cluster.ALTThreadPool;
import com.huawei.gaussdb.jdbc.jdbc.alt.connection.GnsConnectTask;
import com.huawei.gaussdb.jdbc.jdbc.alt.connection.GnsConnection;
import com.huawei.gaussdb.jdbc.jdbc.alt.connection.GnsConnectionFactoryImpl;
import com.huawei.gaussdb.jdbc.jdbc.alt.connection.GnsConnectionMonitor;
import com.huawei.gaussdb.jdbc.jdbc.alt.connection.GnsConnectionPropParser;
import com.huawei.gaussdb.jdbc.jdbc.alt.enums.GnsConnStatus;
import com.huawei.gaussdb.jdbc.jdbc.alt.util.LoggerUtil;
import com.huawei.gaussdb.jdbc.log.Log;
import com.huawei.gaussdb.jdbc.log.Logger;
import com.huawei.gaussdb.jdbc.util.HostSpec;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;

public class GnsConnectionTimerTask
implements Runnable {
    private static final Log LOGGER = Logger.getLogger(GnsConnectionFactoryImpl.class.getName());
    private final Properties properties;
    private final String altClusterId;
    private final ALTContext context;

    public GnsConnectionTimerTask(Properties properties, ALTContext context) {
        this.properties = properties;
        this.altClusterId = GnsConnectionPropParser.getAltClusterId(properties);
        this.context = context;
    }

    @Override
    public void run() {
        this.reConnectGnsIfNeeded();
        this.sendHeadBeatPackage();
    }

    private void reConnectGnsIfNeeded() {
        GnsConnectTask gnsConnectTask = this.findGnsConnectTask();
        if (gnsConnectTask == null || gnsConnectTask.isClosed() && !gnsConnectTask.isTacTimeout()) {
            this.reConnectGns();
            return;
        }
        if (gnsConnectTask.isDisconnected()) {
            gnsConnectTask.setGnsConnStatus(GnsConnStatus.TIME_OUT);
            gnsConnectTask.close();
        }
    }

    private void reConnectGns() {
        LoggerUtil.debug(LOGGER, "Gns disconnected, reconnect to gns");
        List<HostSpec> gnsHostSpecs = GnsConnectionPropParser.getGnsHostSpecs(this.properties);
        Collections.shuffle(gnsHostSpecs);
        GnsConnectTask gnsConnectTask = new GnsConnectTask(this.properties, this.context);
        gnsConnectTask.lock();
        this.executeTask(gnsConnectTask);
        if (!gnsConnectTask.waitOnLock(this.getAllGnsConnectTimeout())) {
            LoggerUtil.warn(LOGGER, "Connect to gns timeout");
            gnsConnectTask.setGnsConnStatus(GnsConnStatus.TIME_OUT);
        } else {
            this.addGnsConnectTask(gnsConnectTask);
        }
    }

    private void sendHeadBeatPackage() {
        GnsConnectTask gnsConnectTask = this.findGnsConnectTask();
        if (gnsConnectTask != null && gnsConnectTask.getGnsConnStatus() == GnsConnStatus.CONNECTED) {
            GnsConnection conn = gnsConnectTask.getConn();
            if (conn == null) {
                return;
            }
            try {
                conn.sendHeartBeatPacket();
            }
            catch (IOException e) {
                LoggerUtil.debug(LOGGER, "Fail to send heart beat packet");
            }
        }
    }

    private void executeTask(Runnable runnable) {
        ALTThreadPool altThreadPool = this.context.getALTThreadPool();
        altThreadPool.executeTask(runnable);
    }

    private void addGnsConnectTask(GnsConnectTask gnsConnectTask) {
        GnsConnectionMonitor gnsConnectionMonitor = this.context.getGnsConnectionMonitor();
        gnsConnectionMonitor.addGnsConnectTask(this.altClusterId, gnsConnectTask);
    }

    private GnsConnectTask findGnsConnectTask() {
        GnsConnectionMonitor gnsConnectionMonitor = this.context.getGnsConnectionMonitor();
        return gnsConnectionMonitor.findGnsConnectTask(this.altClusterId);
    }

    private long getAllGnsConnectTimeout() {
        GnsConnectionMonitor gnsConnectionMonitor = this.context.getGnsConnectionMonitor();
        List<HostSpec> gnsHostSpecs = GnsConnectionPropParser.getGnsHostSpecs(this.properties);
        return gnsConnectionMonitor.getAllGnsConnectTimeout(this.altClusterId, gnsHostSpecs.size());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GnsConnectionTimerTask)) {
            return false;
        }
        GnsConnectionTimerTask that = (GnsConnectionTimerTask)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.altClusterId, that.altClusterId) && Objects.equals(this.context, that.context);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.altClusterId, this.context);
    }

    public String toString() {
        return "GnsConnectionTimerTask{properties=" + this.properties + ", altClusterId='" + this.altClusterId + '\'' + ", context=" + this.context + '}';
    }
}

