/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.alt.fan;

import com.huawei.gaussdb.jdbc.jdbc.alt.cluster.ALTContext;
import com.huawei.gaussdb.jdbc.jdbc.alt.cluster.ALTThreadPool;
import com.huawei.gaussdb.jdbc.jdbc.alt.connection.GnsConnectionMonitor;
import com.huawei.gaussdb.jdbc.jdbc.alt.enums.FanEventType;
import com.huawei.gaussdb.jdbc.jdbc.alt.fan.DBConnectionTracker;
import com.huawei.gaussdb.jdbc.jdbc.alt.fan.FanTask;
import com.huawei.gaussdb.jdbc.jdbc.alt.tac.TacTaskProcessingTask;
import com.huawei.gaussdb.jdbc.jdbc.alt.tac.TacTracker;
import com.huawei.gaussdb.jdbc.jdbc.alt.util.LoggerUtil;
import com.huawei.gaussdb.jdbc.log.Log;
import com.huawei.gaussdb.jdbc.log.Logger;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;

public class FanTaskProcessingTask
implements Runnable {
    private static final Log LOGGER = Logger.getLogger(FanTaskProcessingTask.class.getName());
    private final LinkedBlockingQueue<FanTask> linkedBlockingQueue;
    private final ALTContext context;

    public FanTaskProcessingTask(LinkedBlockingQueue<FanTask> linkedBlockingQueue, ALTContext context) {
        this.linkedBlockingQueue = linkedBlockingQueue;
        this.context = context;
    }

    @Override
    public void run() {
        while (true) {
            FanTask task;
            try {
                task = this.linkedBlockingQueue.take();
            }
            catch (InterruptedException e) {
                return;
            }
            if (task.getFanEventType() == FanEventType.EXIT) break;
            this.dealWithFanTask(task);
        }
        LoggerUtil.debug(LOGGER, "Exit fanTask process task");
    }

    private void dealWithFanTask(FanTask task) {
        DBConnectionTracker dbConnectionTracker = this.context.getDBConnectionTracker();
        TacTracker tacTracker = this.context.getTacTracker();
        ALTThreadPool threadPool = this.context.getALTThreadPool();
        GnsConnectionMonitor gnsConnectionMonitor = this.context.getGnsConnectionMonitor();
        switch (task.getFanEventType()) {
            case TAC_SHUT_DOWN_ALL: 
            case TAC_SHUT_DOWN_NODE: 
            case TAC_SHUT_DOWN_DN: 
            case TAC_SWITCHER_OVER: {
                String altClusterId = task.getAltClusterId();
                if (tacTracker.isInTacProcess(altClusterId)) {
                    LoggerUtil.warn(LOGGER, "In tac process, the tac fan event will be skipped");
                    break;
                }
                TacTaskProcessingTask tacTaskProcessingTask = new TacTaskProcessingTask(task, this.context);
                threadPool.executeTask(tacTaskProcessingTask);
                break;
            }
            case NODE_DOWN: {
                if (dbConnectionTracker.isAltDist(task.getAltClusterId())) break;
                dbConnectionTracker.nodeDown(task);
                break;
            }
            case FAN_CN_DOWN: {
                dbConnectionTracker.nodeDown(task);
                break;
            }
            case NODE_UP: {
                if (dbConnectionTracker.isAltDist(task.getAltClusterId())) break;
                dbConnectionTracker.nodeUp(task);
                break;
            }
            case FAN_CN_UP: {
                dbConnectionTracker.nodeUp(task);
                break;
            }
            case TAC_TIMEOUT: {
                LoggerUtil.warn(LOGGER, "Timeout when deal with planned FanTask, all db connections will be removed, gns will be disconnected");
                String altClusterId = task.getAltClusterId();
                tacTracker.startStopTac(altClusterId);
                dbConnectionTracker.cleanAltClusterInfo(altClusterId);
                gnsConnectionMonitor.unRegister(altClusterId);
                break;
            }
            default: {
                LoggerUtil.warn(LOGGER, "Unknown type of FanTask : " + (Object)((Object)task.getFanEventType()));
            }
        }
    }

    public String toString() {
        return "FanTaskProcessingTask{linkedBlockingQueueSize=" + this.linkedBlockingQueue.size() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FanTaskProcessingTask)) {
            return false;
        }
        FanTaskProcessingTask that = (FanTaskProcessingTask)o;
        return Objects.equals(this.linkedBlockingQueue, that.linkedBlockingQueue);
    }

    public int hashCode() {
        return Objects.hash(this.linkedBlockingQueue);
    }
}

