/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mongodb.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.mongodb.MongoContext;
import com.lubanops.apm.plugin.mongodb.MongoParser;
import com.lubanops.apm.plugin.mongodb.MongoStatsConfig;
import com.lubanops.apm.plugin.mongodb.MongoUtils;
import com.lubanops.apm.plugin.mongodb.collector.MongoDbCollector;
import com.lubanops.apm.plugin.mongodb.interceptor.ServerRunCommandInterceptor;
import com.mongodb.MongoNamespace;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerType;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonValue;

public class CommandProtocolExecutionInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (MongoDbCollector.INSTANCE.isEnable()) {
                CommandProtocolExecutionInterceptor.commandProtocolOnStart(object, args, className, methodName);
            }
        }
        catch (Exception commandProtocolExecutionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)commandProtocolExecutionException);
        }
        return new Object[0];
    }

    public static void commandProtocolOnStart(Object object, Object[] args, String className, String methodName) throws Exception {
        if (args[0] instanceof AttributeAccess) {
            AttributeAccess access = (AttributeAccess)args[0];
            Object[] attributes = access.getLopsFileds();
            MongoNamespace namespace = (MongoNamespace)attributes[0];
            BsonDocument command = (BsonDocument)attributes[1];
            String namespaceStr = MongoContext.getNamespace();
            if (namespaceStr.equals("?") && namespace != null) {
                namespaceStr = namespace.getDatabaseName();
            }
            String commandStr = command == null ? "?" : MongoParser.parseCommand(command, MongoDbCollector.getMaximumCommandLength(), false);
            SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"MongoDb");
            Object connection = ((AttributeAccess)object).getLopsFileds()[0];
            ConnectionDescription description = MongoUtils.getConnectionDescription(connection);
            String serverAddr = description.getServerAddress().toString();
            ServerType serverType = description.getServerType();
            MongoDbCollector.onStart(namespaceStr, commandStr, serverAddr);
            ServerRunCommandInterceptor.onStart(serverAddr, serverType);
            if (spanEvent != null) {
                spanEvent.addTag("namespace", namespaceStr);
                spanEvent.addTag("command", commandStr);
                if (MongoStatsConfig.isParseOriginalCommand) {
                    String originalCommand = command == null ? "?" : MongoParser.parseCommand(command, MongoDbCollector.getMaximumCommandLength(), true);
                    spanEvent.addTag("original command", originalCommand);
                }
            }
        }
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (MongoDbCollector.INSTANCE.isEnable()) {
                CommandProtocolExecutionInterceptor.commandProtocolOnError(object, args, e, className, methodName);
            }
        }
        catch (Exception commandProtocolExecutionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)commandProtocolExecutionException);
        }
    }

    public static void commandProtocolOnError(Object object, Object[] args, Throwable e, String className, String methodName) {
        MongoDbCollector.onException(e);
        MongoDbCollector.onError(TraceCollector.getTraceId());
        ServerRunCommandInterceptor.onError();
        if (args[0] instanceof AttributeAccess) {
            TraceCollector.onError((Throwable)e);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (MongoDbCollector.INSTANCE.isEnable()) {
                CommandProtocolExecutionInterceptor.commandProtocolOnFinally(object, args, result, className, methodName);
            }
        }
        catch (Exception commandProtocolExecutionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)commandProtocolExecutionException);
        }
    }

    public static void commandProtocolOnFinally(Object object, Object[] args, Object result, String className, String methodName) {
        if (args[0] instanceof AttributeAccess) {
            if (result instanceof BsonDocument) {
                BsonDocument doc = (BsonDocument)result;
                CommandProtocolExecutionInterceptor.incrementCount(doc);
            }
            MongoDbCollector.onFinally();
            ServerRunCommandInterceptor.onFinally();
            TraceCollector.onFinally();
        }
    }

    private static void incrementCount(BsonDocument doc) {
        long queryCount = 0L;
        long updateCount = 0L;
        long findAndWriteCount = CommandProtocolExecutionInterceptor.countsForFindAndModifiedResult(doc);
        queryCount += CommandProtocolExecutionInterceptor.queryCountForQueryResult(doc) + findAndWriteCount;
        updateCount += CommandProtocolExecutionInterceptor.updateCountForWriteResult(doc) + findAndWriteCount + CommandProtocolExecutionInterceptor.updateCountForMapReduceResult(doc);
        SpanEvent spanEvent = TraceCollector.getSpanEvent();
        if (spanEvent != null) {
            if (queryCount != 0L) {
                spanEvent.addTag("query count", String.valueOf(queryCount));
            }
            if (updateCount != 0L) {
                spanEvent.addTag("update count", String.valueOf(updateCount));
            }
        }
        MongoDbCollector.incrementQueryCount(queryCount);
        MongoDbCollector.incrementUpdateCount(updateCount);
    }

    private static long queryCountForQueryResult(BsonDocument doc) {
        BsonValue cursorVal;
        long queryCount = 0L;
        if (doc.containsKey((Object)"cursor") && (cursorVal = doc.get((Object)"cursor")).isDocument()) {
            BsonValue batchObject;
            BsonDocument cursorDoc = (BsonDocument)cursorVal;
            if (cursorDoc.containsKey((Object)"firstBatch")) {
                BsonValue batchObject2 = cursorDoc.get((Object)"firstBatch");
                if (batchObject2 instanceof AttributeAccess) {
                    AttributeAccess batchAccess = (AttributeAccess)batchObject2;
                    queryCount = ((List)batchAccess.getLopsFileds()[0]).size();
                }
            } else if (cursorDoc.containsKey((Object)"nextBatch") && (batchObject = cursorDoc.get((Object)"nextBatch")) instanceof AttributeAccess) {
                AttributeAccess batchAccess = (AttributeAccess)batchObject;
                queryCount = ((List)batchAccess.getLopsFileds()[0]).size();
            }
        }
        return queryCount;
    }

    private static long updateCountForWriteResult(BsonDocument doc) {
        BsonValue upsertValue;
        long updateCount = 0L;
        BsonValue val = null;
        if (doc.containsKey((Object)"nModified")) {
            val = doc.get((Object)"nModified");
        } else if (doc.containsKey((Object)"n")) {
            val = doc.get((Object)"n");
        }
        if (val != null) {
            if (val.isInt32()) {
                updateCount = ((BsonInt32)val).getValue();
            } else if (val.isInt64()) {
                updateCount = ((BsonInt64)val).getValue();
            }
        }
        if (doc.containsKey((Object)"upserted") && (upsertValue = doc.get((Object)"upserted")).isArray()) {
            BsonArray upsertArr = (BsonArray)upsertValue;
            updateCount += (long)upsertArr.size();
        }
        return updateCount;
    }

    private static long countsForFindAndModifiedResult(BsonDocument doc) {
        BsonDocument lastErrorObjectDoc;
        BsonValue lastErrorObjectVal;
        long count = 0L;
        BsonValue val = null;
        if (doc.containsKey((Object)"lastErrorObject") && (lastErrorObjectVal = doc.get((Object)"lastErrorObject")).isDocument() && (lastErrorObjectDoc = (BsonDocument)lastErrorObjectVal).containsKey((Object)"n")) {
            val = lastErrorObjectDoc.get((Object)"n");
        }
        if (val != null) {
            if (val.isInt32()) {
                count = ((BsonInt32)val).getValue();
            } else if (val.isInt64()) {
                count = ((BsonInt64)val).getValue();
            }
        }
        return count;
    }

    private static long updateCountForMapReduceResult(BsonDocument doc) {
        BsonValue outputVal;
        BsonDocument countsDoc;
        BsonValue countsValue;
        long updateCount = 0L;
        if (doc.containsKey((Object)"counts") && (countsValue = doc.get((Object)"counts")).isDocument() && (countsDoc = (BsonDocument)countsValue).containsKey((Object)"output") && (outputVal = countsDoc.get((Object)"output")).isInt32()) {
            updateCount += (long)((BsonInt32)outputVal).getValue();
        }
        return updateCount;
    }
}

