/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mongodb.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.plugin.mongodb.collector.MongoDbCollector;
import com.lubanops.apm.plugin.mongodb.interceptor.CommandProtocolExecutionInterceptor;
import com.lubanops.apm.plugin.mongodb.interceptor.LegacyProtocolExecutionInterceptor;

public class ProtocolExecutionInterceptor
implements Interceptor {
    private static final String COMMAND_PROTOCOL_NAME = "CommandProtocol";

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (MongoDbCollector.INSTANCE.isEnable()) {
                String protocolName = args[0].getClass().getSimpleName();
                if (protocolName.equals(COMMAND_PROTOCOL_NAME)) {
                    CommandProtocolExecutionInterceptor.commandProtocolOnStart(object, args, className, methodName);
                } else {
                    LegacyProtocolExecutionInterceptor.legacyProtocolOnStart(object, args, className, methodName);
                }
            }
        }
        catch (Exception protocolExecutionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)protocolExecutionException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (MongoDbCollector.INSTANCE.isEnable()) {
                String protocolName = args[0].getClass().getSimpleName();
                if (protocolName.equals(COMMAND_PROTOCOL_NAME)) {
                    CommandProtocolExecutionInterceptor.commandProtocolOnError(object, args, e, className, methodName);
                } else {
                    LegacyProtocolExecutionInterceptor.legacyProtocolOnError(object, args, e, className, methodName);
                }
            }
        }
        catch (Exception protocolExecutionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)protocolExecutionException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (MongoDbCollector.INSTANCE.isEnable()) {
                String protocolName = args[0].getClass().getSimpleName();
                if (protocolName.equals(COMMAND_PROTOCOL_NAME)) {
                    CommandProtocolExecutionInterceptor.commandProtocolOnFinally(object, args, result, className, methodName);
                } else {
                    LegacyProtocolExecutionInterceptor.legacyProtocolOnFinally(object, args, result, className, methodName);
                }
            }
        }
        catch (Exception protocolExecutionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)protocolExecutionException);
        }
    }
}

