/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mongodb.stats;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.plugin.common.DefaultSectionStats;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class MongoClientStats
extends DefaultSectionStats {
    private volatile long queryCountOld = 0L;
    private volatile long updateCountOld = 0L;
    private final AtomicReference<String> lastError = new AtomicReference();
    private final AtomicReference<String> slowTraceId = new AtomicReference();
    private final AtomicReference<String> errorTraceId = new AtomicReference();
    private final AtomicLong queryCount = new AtomicLong();
    private final AtomicLong updateCount = new AtomicLong();

    public void incrementQueryCount(long count) {
        this.queryCount.addAndGet(count);
    }

    public void incrementUpdateCount(long count) {
        this.updateCount.addAndGet(count);
    }

    public void onError(String errorTraceId) {
        this.onError();
        this.setErrorTraceId(errorTraceId);
    }

    public void setSlowTraceId(String slowTraceId) {
        if (slowTraceId != null) {
            this.slowTraceId.set(slowTraceId);
        }
    }

    public void setErrorTraceId(String errorTraceId) {
        if (this.errorTraceId.get() == null && errorTraceId != null) {
            this.errorTraceId.set(errorTraceId);
        }
    }

    public MonitorDataRow getStatus() {
        MonitorDataRow row = super.getStatus();
        row.put((Object)"lastError", (Object)this.lastError.get());
        row.put((Object)"slowTraceId", (Object)this.slowTraceId.get());
        row.put((Object)"errorTraceId", (Object)this.errorTraceId.get());
        row.put((Object)"queryCount", (Object)this.queryCount.get());
        row.put((Object)"updateCount", (Object)this.updateCount.get());
        return row;
    }

    public MonitorDataRow harvest(int[] newRanges) {
        long queryCountNew = this.queryCount.get();
        long updateCountNew = this.updateCount.get();
        MonitorDataRow row = super.harvest(newRanges);
        if (row != null) {
            row.put((Object)"lastError", this.lastError.getAndSet(null));
            row.put((Object)"slowTraceId", this.slowTraceId.getAndSet(null));
            row.put((Object)"errorTraceId", this.errorTraceId.getAndSet(null));
            row.put((Object)"queryCount", (Object)(queryCountNew - this.queryCountOld));
            row.put((Object)"updateCount", (Object)(updateCountNew - this.updateCountOld));
        }
        this.queryCountOld = queryCountNew;
        this.updateCountOld = updateCountNew;
        return row;
    }
}

